/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import courgette.api.CourgetteRunLevel;
import courgette.integration.extentreports.ExtentReportsBuilder;
import courgette.integration.extentreports.ExtentReportsProperties;
import courgette.integration.reportportal.ReportPortalPublisher;
import courgette.integration.slack.SlackPublisher;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteFeatureRunner;
import courgette.runtime.CourgetteHtmlReporter;
import courgette.runtime.CourgetteNdJsonCreator;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgettePublisher;
import courgette.runtime.CourgetteReporter;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteRuntimeOptions;
import courgette.runtime.CourgetteRuntimePublisher;
import courgette.runtime.RunStatus;
import courgette.runtime.event.CourgetteEvent;
import courgette.runtime.report.JsonReportParser;
import courgette.runtime.report.model.Feature;
import courgette.runtime.utils.FileUtils;
import io.cucumber.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class CourgetteRunner {
    private final List<Callable<Boolean>> runners = new ArrayList<Callable<Boolean>>();
    private final CopyOnWriteArrayList<String> reruns = new CopyOnWriteArrayList();
    private final Map<String, CopyOnWriteArrayList<String>> reports = new HashMap<String, CopyOnWriteArrayList<String>>();
    private final List<CourgetteRunnerInfo> runnerInfoList;
    private final CourgetteProperties courgetteProperties;
    private final CourgetteRuntimeOptions defaultRuntimeOptions;
    private final List<CourgetteRunResult> runResults = new ArrayList<CourgetteRunResult>();
    private final CourgetteRuntimePublisher runtimePublisher;
    private final boolean rerunFailedScenarios;
    private final boolean canRunFeatures;
    private List<Feature> reportFeatures = new ArrayList<Feature>();
    private Map<io.cucumber.core.gherkin.Feature, List<List<Messages.Envelope>>> reportMessages = new HashMap<io.cucumber.core.gherkin.Feature, List<List<Messages.Envelope>>>();
    private String cucumberReportUrl = "#";

    public CourgetteRunner(List<CourgetteRunnerInfo> runnerInfoList, CourgetteProperties courgetteProperties) {
        this.runnerInfoList = runnerInfoList;
        this.canRunFeatures = runnerInfoList.size() > 0;
        this.courgetteProperties = courgetteProperties;
        this.rerunFailedScenarios = courgetteProperties.getCourgetteOptions().rerunFailedScenarios();
        this.defaultRuntimeOptions = new CourgetteRuntimeOptions(courgetteProperties);
        this.runtimePublisher = this.createRuntimePublisher(courgetteProperties, this.extractRunnerInfoFeatures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunStatus run() {
        ExecutorService executor = Executors.newFixedThreadPool(this.optimizedThreadCount());
        ArrayDeque<CourgetteRunnerInfo> runnerQueue = new ArrayDeque<CourgetteRunnerInfo>(this.runnerInfoList);
        while (!runnerQueue.isEmpty()) {
            CourgetteRunnerInfo runnerInfo = (CourgetteRunnerInfo)runnerQueue.poll();
            Map<String, List<String>> cucumberArgs = runnerInfo.getRuntimeOptions();
            io.cucumber.core.gherkin.Feature feature = runnerInfo.getFeature();
            Integer lineId = runnerInfo.getLineId();
            String featureUri = cucumberArgs.get(null).get(0);
            this.runners.add(() -> {
                try {
                    if (this.runFeature(cucumberArgs)) {
                        this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, featureUri, CourgetteRunResult.Status.PASSED));
                        Boolean bl = true;
                        return bl;
                    }
                    String rerunFile = runnerInfo.getRerunFile();
                    String rerun = FileUtils.readFile(rerunFile, false);
                    if (this.rerunFailedScenarios && rerun != null) {
                        if (this.courgetteProperties.isFeatureRunLevel()) {
                            CourgetteRunResult rerunResult = new CourgetteRunResult(feature, lineId, featureUri, CourgetteRunResult.Status.RERUN);
                            this.runResults.add(rerunResult);
                            if (this.rerunFeature(cucumberArgs, rerunResult)) {
                                this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, featureUri, CourgetteRunResult.Status.PASSED_AFTER_RERUN));
                                Boolean bl = true;
                                return bl;
                            }
                            this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, featureUri, CourgetteRunResult.Status.FAILED_AFTER_RERUN));
                        } else {
                            Map<String, List<String>> rerunCucumberArgs = runnerInfo.getRerunRuntimeOptions(rerun);
                            String rerunFeatureUri = rerunCucumberArgs.get(null).get(0);
                            CourgetteRunResult rerunResult = new CourgetteRunResult(feature, lineId, rerunFeatureUri, CourgetteRunResult.Status.RERUN);
                            this.runResults.add(rerunResult);
                            if (this.rerunFeature(rerunCucumberArgs, rerunResult)) {
                                this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, rerunFeatureUri, CourgetteRunResult.Status.PASSED_AFTER_RERUN));
                                Boolean bl = true;
                                return bl;
                            }
                            this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, rerunFeatureUri, CourgetteRunResult.Status.FAILED_AFTER_RERUN));
                        }
                    } else {
                        this.addResultAndPublish(runnerInfo, new CourgetteRunResult(feature, lineId, featureUri, CourgetteRunResult.Status.FAILED));
                    }
                    if (rerun != null) {
                        this.reruns.add(rerun);
                    }
                }
                finally {
                    runnerInfo.getReportFiles().forEach(reportFile -> {
                        if (reportFile.contains(this.courgetteProperties.getSessionId())) {
                            boolean isJson = reportFile.endsWith(".json");
                            String report = isJson ? this.prettyJson(FileUtils.readFile(reportFile, true)) : FileUtils.readFile(reportFile, true);
                            boolean isNdJson = reportFile.endsWith(".ndjson");
                            if (isNdJson) {
                                this.reportMessages.computeIfAbsent(feature, r -> new ArrayList()).addAll(Collections.singleton(CourgetteNdJsonCreator.createMessages(report)));
                            } else {
                                this.reports.computeIfAbsent((String)reportFile, r -> new CopyOnWriteArrayList()).add(report);
                            }
                        }
                    });
                }
                return false;
            });
        }
        try {
            this.runtimePublisher.publish(CourgetteEvent.TEST_RUN_STARTED);
            executor.invokeAll(this.runners);
        }
        catch (InterruptedException e) {
            CourgetteException.printExceptionStackTrace(e);
        }
        finally {
            this.runtimePublisher.publish(CourgetteEvent.TEST_RUN_FINISHED);
            executor.shutdownNow();
        }
        boolean hasErrors = this.reportMessages.values().stream().anyMatch(List::isEmpty);
        return hasErrors ? RunStatus.ERROR : RunStatus.OK;
    }

    public void createCucumberReport() {
        List<String> reportFiles = this.defaultRuntimeOptions.getReportFiles();
        CourgetteReporter courgetteReporter = new CourgetteReporter(this.reports, this.reportMessages, this.defaultRuntimeOptions, this.courgetteProperties);
        reportFiles.forEach(reportFile -> {
            boolean mergeTestCaseName = this.courgetteProperties.isReportPortalPluginEnabled() && reportFile.equalsIgnoreCase(this.defaultRuntimeOptions.getCourgetteReportXmlForReportPortal());
            courgetteReporter.createCucumberReport((String)reportFile, mergeTestCaseName);
        });
        Optional<String> publishedReport = courgetteReporter.publishCucumberReport();
        publishedReport.ifPresent(reportUrl -> {
            this.cucumberReportUrl = reportUrl;
        });
    }

    public void createRerunFile() {
        ArrayList<String> rerun = new ArrayList<String>();
        this.reruns.sort(String::compareTo);
        rerun.addAll(this.reruns);
        String rerunFile = this.defaultRuntimeOptions.getCucumberRerunFile();
        if (rerunFile != null) {
            FileUtils.writeFile(rerunFile, String.join((CharSequence)"\n", rerun));
        }
    }

    public void createCourgetteReport() {
        try {
            if (this.courgetteProperties.isCourgetteHtmlReportEnabled()) {
                CourgetteHtmlReporter courgetteReport = new CourgetteHtmlReporter(this.courgetteProperties, this.runResults, this.getReportFeatures(), this.cucumberReportUrl);
                courgetteReport.create();
            }
        }
        catch (Exception e) {
            CourgetteException.printExceptionStackTrace(e);
        }
    }

    public void createCourgetteExtentReports() {
        try {
            ExtentReportsProperties extentReportsProperties = new ExtentReportsProperties(this.courgetteProperties);
            ExtentReportsBuilder extentReportsBuilder = ExtentReportsBuilder.create(extentReportsProperties, this.getReportFeatures());
            extentReportsBuilder.buildReport();
        }
        catch (Exception e) {
            CourgetteException.printExceptionStackTrace(e);
        }
    }

    public List<CourgetteRunResult> getFailures() {
        return this.runResults.stream().filter(t -> t.getStatus().equals((Object)CourgetteRunResult.Status.FAILED) || t.getStatus().equals((Object)CourgetteRunResult.Status.FAILED_AFTER_RERUN)).collect(Collectors.toList());
    }

    public boolean canRunFeatures() {
        return this.canRunFeatures;
    }

    public void cleanupCourgetteHtmlReportFiles() {
        FileUtils.deleteDirectorySilently(this.defaultRuntimeOptions.getCourgetteReportDataDirectory());
    }

    private boolean runFeature(Map<String, List<String>> args) {
        try {
            return 0 == new CourgetteFeatureRunner(args, this.courgetteProperties).run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private boolean rerunFeature(Map<String, List<String>> args, CourgetteRunResult rerunResult) {
        int rerunAttempts = this.courgetteProperties.getCourgetteOptions().rerunAttempts();
        rerunAttempts = Math.max(rerunAttempts, 1);
        while (rerunAttempts-- > 0) {
            this.runtimePublisher.publish(CourgetteEvent.TEST_RERUN, rerunResult);
            if (!this.runFeature(args)) continue;
            return true;
        }
        return false;
    }

    private String prettyJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Object jsonObject = mapper.readValue(json, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (IOException e) {
            return json;
        }
    }

    private List<Feature> getReportFeatures() {
        if (this.reportFeatures.isEmpty()) {
            File reportJson = new File(this.defaultRuntimeOptions.getCourgetteReportJson());
            CourgetteRunLevel runLevel = this.courgetteProperties.getCourgetteOptions().runLevel();
            if (reportJson.exists()) {
                this.reportFeatures = JsonReportParser.create(reportJson, runLevel).getReportFeatures();
            }
        }
        return this.reportFeatures;
    }

    private Integer optimizedThreadCount() {
        return this.courgetteProperties.getMaxThreads() > this.runnerInfoList.size() ? this.runnerInfoList.size() : (this.courgetteProperties.getMaxThreads() < 1 ? 1 : this.courgetteProperties.getMaxThreads());
    }

    private List<io.cucumber.core.gherkin.Feature> extractRunnerInfoFeatures() {
        return this.runnerInfoList.stream().map(CourgetteRunnerInfo::getFeature).collect(Collectors.toList());
    }

    private CourgetteRuntimePublisher createRuntimePublisher(CourgetteProperties courgetteProperties, List<io.cucumber.core.gherkin.Feature> features) {
        HashSet<CourgettePublisher> publishers = new HashSet<CourgettePublisher>();
        publishers.add(new SlackPublisher(courgetteProperties));
        publishers.add(new ReportPortalPublisher(courgetteProperties, features));
        return new CourgetteRuntimePublisher(publishers);
    }

    private synchronized void addResultAndPublish(CourgetteRunnerInfo courgetteRunnerInfo, CourgetteRunResult courgetteRunResult) {
        this.runResults.add(courgetteRunResult);
        switch (courgetteRunResult.getStatus()) {
            case PASSED: {
                this.runtimePublisher.publish(CourgetteEvent.TEST_PASSED, courgetteRunnerInfo, courgetteRunResult);
                break;
            }
            case PASSED_AFTER_RERUN: {
                this.runtimePublisher.publish(CourgetteEvent.TEST_PASSED_AFTER_RERUN, courgetteRunnerInfo, courgetteRunResult);
                break;
            }
            case FAILED: 
            case FAILED_AFTER_RERUN: {
                this.runtimePublisher.publish(CourgetteEvent.TEST_FAILED, courgetteRunnerInfo, courgetteRunResult);
            }
        }
    }
}

