/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.report;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteException;
import courgette.runtime.report.model.Embedding;
import courgette.runtime.report.model.Feature;
import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Result;
import courgette.runtime.report.model.Scenario;
import courgette.runtime.report.model.Step;
import courgette.runtime.report.model.Tag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class JsonReportParser {
    private File jsonFile;
    private List<Feature> features;
    private CourgetteRunLevel runLevel;
    private static final String START_TIMESTAMP_ATTRIBUTE = "start_timestamp";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String URI_ATTRIBUTE = "uri";
    private static final String ELEMENTS_ATTRIBUTE = "elements";
    private static final String STEPS_ATTRIBUTE = "steps";
    private static final String KEYWORD_ATTRIBUTE = "keyword";
    private static final String LINE_ATTRIBUTE = "line";
    private static final String RESULT_ATTRIBUTE = "result";
    private static final String STATUS_ATTRIBUTE = "status";
    private static final String DURATION_ATTRIBUTE = "duration";
    private static final String ERROR_MESSAGE_ATTRIBUTE = "error_message";
    private static final String BEFORE_ATTRIBUTE = "before";
    private static final String AFTER_ATTRIBUTE = "after";
    private static final String MATCH_ATTRIBUTE = "match";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String EMBEDDINGS_ATTRIBUTE = "embeddings";
    private static final String OUTPUT_ATTRIBUTE = "output";
    private static final String DATA_ATTRIBUTE = "data";
    private static final String MIME_TYPE_ATTRIBUTE = "mime_type";
    private static final String ROWS_ATTRIBUTE = "rows";
    private static final String CELLS_ATTRIBUTE = "cells";
    private static final String TAGS_ATTRIBUTE = "tags";

    private JsonReportParser(File jsonFile, CourgetteRunLevel runLevel) {
        this.jsonFile = jsonFile;
        this.runLevel = runLevel;
        this.features = new ArrayList<Feature>();
    }

    public static JsonReportParser create(File jsonFile, CourgetteRunLevel runLevel) {
        return new JsonReportParser(jsonFile, runLevel);
    }

    public List<Feature> getReportFeatures() {
        try {
            this.parseJsonReport();
        }
        catch (FileNotFoundException | IllegalStateException e) {
            throw new CourgetteException(e);
        }
        return this.runLevel.equals((Object)CourgetteRunLevel.FEATURE) ? this.features : this.convertToFeatureList(this.features);
    }

    private List<Feature> convertToFeatureList(List<Feature> features) {
        HashMap<String, List> scenarioMap = new HashMap<String, List>();
        features.forEach(feature -> {
            String uri = feature.getUri();
            if (scenarioMap.containsKey(uri)) {
                List scenarioList = (List)scenarioMap.get(uri);
                scenarioList.addAll(feature.getScenarios());
                scenarioList.sort(Comparator.comparingInt(Scenario::getLine));
                scenarioMap.put(uri, scenarioList);
            } else {
                scenarioMap.put(uri, feature.getScenarios());
            }
        });
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        scenarioMap.forEach((key, value) -> {
            Feature feature = features.stream().filter(f -> f.getUri().equals(key)).findFirst().get();
            featureList.add(new Feature(feature.getName(), feature.getUri(), (List<Scenario>)value));
        });
        return featureList;
    }

    private void parseJsonReport() throws FileNotFoundException {
        JsonParser jsonParser = new JsonParser();
        JsonElement json = jsonParser.parse((Reader)new FileReader(this.jsonFile));
        if (json instanceof JsonNull) {
            return;
        }
        JsonArray reportJson = (JsonArray)json;
        for (JsonElement report : reportJson) {
            JsonObject feature = report.getAsJsonObject();
            String featureName = feature.get(NAME_ATTRIBUTE).getAsString();
            String featureUri = feature.get(URI_ATTRIBUTE).getAsString();
            JsonArray elements = (JsonArray)feature.get(ELEMENTS_ATTRIBUTE);
            Iterator elementsIterator = elements.iterator();
            ArrayList<JsonArray> backgroundSteps = new ArrayList<JsonArray>();
            while (elementsIterator.hasNext()) {
                JsonObject element = ((JsonElement)elementsIterator.next()).getAsJsonObject();
                if (!element.get(KEYWORD_ATTRIBUTE).getAsString().equalsIgnoreCase("Background")) continue;
                JsonArray elementSteps = (JsonArray)element.get(STEPS_ATTRIBUTE);
                backgroundSteps.add(elementSteps);
            }
            elementsIterator = elements.iterator();
            ArrayList<Scenario> scenarioElements = new ArrayList<Scenario>();
            int index = 0;
            while (elementsIterator.hasNext()) {
                JsonObject scenario = ((JsonElement)elementsIterator.next()).getAsJsonObject();
                JsonElement startTimestampElement = scenario.get(START_TIMESTAMP_ATTRIBUTE);
                String startTimestamp = startTimestampElement != null ? startTimestampElement.getAsString() : "";
                String scenarioName = scenario.get(NAME_ATTRIBUTE).getAsString();
                String scenarioKeyword = scenario.get(KEYWORD_ATTRIBUTE).getAsString();
                int scenarioLine = scenario.get(LINE_ATTRIBUTE).getAsInt();
                if (scenarioKeyword.equalsIgnoreCase("Background")) continue;
                ArrayList<Hook> scenarioBefore = new ArrayList<Hook>();
                this.addHook(scenario.get(BEFORE_ATTRIBUTE), scenarioBefore);
                ArrayList<Hook> scenarioAfter = new ArrayList<Hook>();
                this.addHook(scenario.get(AFTER_ATTRIBUTE), scenarioAfter);
                ArrayList allSteps = new ArrayList();
                if (!backgroundSteps.isEmpty()) {
                    allSteps.add(backgroundSteps.get(index++));
                }
                allSteps.addAll(Collections.singleton((JsonArray)scenario.get(STEPS_ATTRIBUTE)));
                ArrayList<Step> scenarioSteps = new ArrayList<Step>();
                allSteps.forEach(steps -> this.addSteps((JsonArray)steps, (List<Step>)scenarioSteps));
                ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
                this.addTags(scenario.get(TAGS_ATTRIBUTE), scenarioTags);
                scenarioElements.add(new Scenario(featureUri, startTimestamp, scenarioName, scenarioKeyword, scenarioLine, scenarioBefore, scenarioAfter, scenarioSteps, scenarioTags));
            }
            this.features.add(new Feature(featureName, featureUri, scenarioElements));
        }
    }

    private void addTags(JsonElement tags, List<Tag> tagList) {
        if (tags != null && tags.getAsJsonArray() != null) {
            tags.getAsJsonArray().forEach(tag -> {
                if (tag.getAsJsonObject() != null) {
                    tagList.add(new Tag(tag.getAsJsonObject().get(NAME_ATTRIBUTE).getAsString()));
                }
            });
        }
    }

    private void addSteps(JsonArray steps, List<Step> stepList) {
        steps.iterator().forEachRemaining(e -> {
            JsonObject step = e.getAsJsonObject();
            JsonObject result = step.get(RESULT_ATTRIBUTE).getAsJsonObject();
            String stepName = step.get(NAME_ATTRIBUTE).getAsString();
            String stepKeyword = step.get(KEYWORD_ATTRIBUTE).getAsString();
            String stepStatus = result.get(STATUS_ATTRIBUTE).getAsString();
            long stepDuration = result.get(DURATION_ATTRIBUTE) != null ? result.get(DURATION_ATTRIBUTE).getAsLong() : 0L;
            String stepErrorMessage = result.get(ERROR_MESSAGE_ATTRIBUTE) != null ? result.get(ERROR_MESSAGE_ATTRIBUTE).getAsString() : null;
            Result stepResult = new Result(stepStatus, stepDuration, stepErrorMessage);
            ArrayList<Hook> stepBefore = new ArrayList<Hook>();
            this.addHook(step.get(BEFORE_ATTRIBUTE), stepBefore);
            ArrayList<Hook> stepAfter = new ArrayList<Hook>();
            this.addHook(step.get(AFTER_ATTRIBUTE), stepAfter);
            ArrayList<Embedding> stepEmbeddings = new ArrayList<Embedding>();
            this.addEmbeddings(step, stepEmbeddings);
            ArrayList<String> stepOutputs = new ArrayList<String>();
            this.addOutputs(step, stepOutputs);
            ArrayList<String> stepRowData = new ArrayList<String>();
            this.addStepRowData(step, stepRowData);
            stepList.add(new Step(stepName, stepKeyword, stepResult, stepBefore, stepAfter, stepEmbeddings, stepOutputs, stepRowData));
        });
    }

    private void addHook(JsonElement source, List<Hook> hooks) {
        if (source != null) {
            for (JsonElement scenarioHook : (JsonArray)source) {
                JsonObject hook = scenarioHook.getAsJsonObject();
                JsonObject hookResult = hook.get(RESULT_ATTRIBUTE).getAsJsonObject();
                String hookStatus = hookResult.get(STATUS_ATTRIBUTE).getAsString();
                long hookDuration = hookResult.get(DURATION_ATTRIBUTE) != null ? hookResult.get(DURATION_ATTRIBUTE).getAsLong() : 0L;
                String hookErrorMessage = hookResult.get(ERROR_MESSAGE_ATTRIBUTE) != null ? hookResult.get(ERROR_MESSAGE_ATTRIBUTE).getAsString() : null;
                Result result = new Result(hookStatus, hookDuration, hookErrorMessage);
                JsonObject match = hook.get(MATCH_ATTRIBUTE).getAsJsonObject();
                String location = match.get(LOCATION_ATTRIBUTE).getAsString();
                if (!location.endsWith(")")) {
                    location = location.substring(0, location.lastIndexOf(")") + 1);
                }
                ArrayList<Embedding> hookEmbeddings = new ArrayList<Embedding>();
                this.addEmbeddings(hook, hookEmbeddings);
                ArrayList<String> hookOutputs = new ArrayList<String>();
                this.addOutputs(hook, hookOutputs);
                hooks.add(new Hook(location, result, hookEmbeddings, hookOutputs));
            }
        }
    }

    private void addEmbeddings(JsonObject source, List<Embedding> embeddingList) {
        JsonArray embeddings = (JsonArray)source.get(EMBEDDINGS_ATTRIBUTE);
        if (embeddings != null) {
            for (JsonElement embedding : embeddings) {
                JsonObject embeddedData = embedding.getAsJsonObject();
                String data = embeddedData.get(DATA_ATTRIBUTE).getAsString();
                String mimeType = embeddedData.get(MIME_TYPE_ATTRIBUTE).getAsString();
                embeddingList.add(new Embedding(data, mimeType));
            }
        }
    }

    private void addOutputs(JsonObject source, List<String> outputList) {
        JsonArray output = (JsonArray)source.get(OUTPUT_ATTRIBUTE);
        if (output != null) {
            for (JsonElement out : output) {
                outputList.add(out.getAsString());
            }
        }
    }

    private void addStepRowData(JsonObject source, List<String> rowData) {
        JsonArray rows = (JsonArray)source.get(ROWS_ATTRIBUTE);
        if (rows != null) {
            rows.iterator().forEachRemaining(c -> {
                JsonArray cellArray = c.getAsJsonObject().get(CELLS_ATTRIBUTE).getAsJsonArray();
                StringBuilder cell = new StringBuilder();
                cellArray.iterator().forEachRemaining(t -> cell.append(t.getAsString()).append(" | "));
                if (cell.length() > 0) {
                    rowData.add("| " + cell.toString());
                }
            });
        }
    }
}

