/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.report.builder;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.report.model.Feature;
import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Result;
import courgette.runtime.report.model.Scenario;
import courgette.runtime.report.model.Step;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HtmlReportBuilder {
    private static final String PASSED = "Passed";
    private static final String PASSED_AFTER_RERUN = "Passed after Rerun";
    private static final String FAILED = "Failed";
    private static final String FAILED_AFTER_RERUN = "Failed after Rerun";
    private static final String SUCCESS = "success";
    private static final String DANGER = "danger";
    private static final String WARNING = "warning";
    private static final String DATA_TARGET = "data_target";
    private static final String FEATURE_NAME = "feature_name";
    private static final String FEATURE_BADGE = "feature_badge";
    private static final String FEATURE_RESULT = "feature_result";
    private static final String FEATURE_SCENARIOS = "feature_scenarios";
    private static final String SCENARIO_NAME = "scenario_name";
    private static final String SCENARIO_BADGE = "scenario_badge";
    private static final String SCENARIO_RESULT = "scenario_result";
    private static final String SCENARIO_TAGS = "scenario_tags";
    private static final String MODAL_TARGET = "modal_target";
    private static final String MODAL_HEADING = "modal_heading";
    private static final String MODAL_FEATURE_LINE = "modal_feature_line";
    private static final String MODAL_BODY = "modal_body";
    private static final String STEP_KEYWORD = "step_keyword";
    private static final String STEP_NAME = "step_name";
    private static final String STEP_DURATION = "step_duration";
    private static final String STEP_BADGE = "step_badge";
    private static final String STEP_RESULT = "step_result";
    private static final String STEP_DATATABLE = "step_datatable";
    private static final String DATATABLE = "datatable";
    private static final String STEP_EXCEPTION = "step_exception";
    private static final String EXCEPTION = "exception";
    private static final String STEP_OUPUT = "step_output";
    private static final String OUTPUT = "output";
    private static final String STEP_EMBEDDING_TEXT = "step_embedding_text";
    private static final String TEXT = "text";
    private static final String STEP_EMBEDDING_IMAGE = "step_embedding_image";
    private static final String IMAGE_ID = "img_id";
    private static final String ROW_INFO = "row_info";
    private static final String TAG = "tag";
    private List<Feature> featureList;
    private List<CourgetteRunResult> courgetteRunResults;
    private CourgetteProperties courgetteProperties;
    private Mustache featureTemplate;
    private Mustache modalTemplate;
    private Mustache modalStepTemplate;
    private Mustache modalEnvironmentTemplate;
    private Mustache modalRowTemplate;
    private Mustache scenarioTemplate;
    private Mustache scenarioTagTemplate;
    private static Function<Result, String> statusLabel = result -> result.getStatus().substring(0, 1).toUpperCase() + result.getStatus().substring(1);
    private static Function<Result, String> statusBadge = result -> {
        String status = result.getStatus();
        return status.equalsIgnoreCase(PASSED) ? SUCCESS : (status.equalsIgnoreCase(FAILED) ? DANGER : WARNING);
    };

    private HtmlReportBuilder(List<Feature> featureList, List<CourgetteRunResult> courgetteRunResults, CourgetteProperties courgetteProperties) {
        this.featureList = featureList;
        this.courgetteRunResults = courgetteRunResults;
        this.courgetteProperties = courgetteProperties;
        this.featureTemplate = this.readTemplate("/report/templates/feature.mustache");
        this.modalTemplate = this.readTemplate("/report/templates/modal.mustache");
        this.modalStepTemplate = this.readTemplate("/report/templates/modal_step.mustache");
        this.modalEnvironmentTemplate = this.readTemplate("/report/templates/modal_environment.mustache");
        this.modalRowTemplate = this.readTemplate("/report/templates/modal_row.mustache");
        this.scenarioTemplate = this.readTemplate("/report/templates/scenario.mustache");
        this.scenarioTagTemplate = this.readTemplate("/report/templates/scenario_tag.mustache");
    }

    public static HtmlReportBuilder create(List<Feature> featureList, List<CourgetteRunResult> courgetteRunResults, CourgetteProperties courgetteProperties) {
        return new HtmlReportBuilder(featureList, courgetteRunResults, courgetteProperties);
    }

    public List<String> getHtmlTableFeatureRows() {
        ArrayList<String> featureRows = new ArrayList<String>(this.featureList.size());
        this.featureList.forEach(feature -> featureRows.add(this.createFeatureRow((Feature)feature, this.courgetteRunResults)));
        return featureRows;
    }

    public List<String> getHtmlModals() {
        int modalCapacity = (int)this.featureList.stream().map(Feature::getScenarios).count() + 1;
        ArrayList<String> modals = new ArrayList<String>(modalCapacity);
        modals.add(this.createEnvironmentInfoModal());
        this.featureList.forEach(feature -> {
            List<Scenario> scenarios = feature.getScenarios();
            scenarios.forEach(scenario -> modals.add(this.createScenarioModal((Feature)feature, (Scenario)scenario)));
        });
        return modals;
    }

    private String createFeatureRow(Feature feature, List<CourgetteRunResult> courgetteRunResults) {
        boolean hasReruns = courgetteRunResults.stream().anyMatch(result -> result.getStatus() == CourgetteRunResult.Status.RERUN);
        LinkedHashMap<String, Object> featureData = new LinkedHashMap<String, Object>();
        String featureId = feature.getCourgetteFeatureId();
        String featureName = feature.getName();
        String featureBadge = feature.passed() ? SUCCESS : DANGER;
        String featureResult = featureBadge.equals(SUCCESS) ? PASSED : FAILED;
        LinkedList<String> scenarioRows = new LinkedList<String>();
        this.createScenarios(feature, scenarioRows, hasReruns);
        featureData.put(DATA_TARGET, featureId);
        featureData.put(FEATURE_NAME, featureName);
        featureData.put(FEATURE_BADGE, featureBadge);
        featureData.put(FEATURE_RESULT, featureResult);
        featureData.put(FEATURE_SCENARIOS, scenarioRows);
        return this.createFromTemplate(this.featureTemplate, featureData);
    }

    private void createScenarios(Feature feature, LinkedList<String> scenarioRows, boolean hasReruns) {
        feature.getScenarios().forEach(scenario -> {
            if (!scenario.getKeyword().equalsIgnoreCase("Background")) {
                scenarioRows.add(this.createScenarioRow(feature.getCourgetteFeatureId(), (Scenario)scenario, hasReruns));
            }
        });
    }

    private List<String> createScenarioTags(Scenario scenario) {
        LinkedList<String> scenarioTags = new LinkedList<String>();
        scenario.getTags().forEach(tag -> {
            LinkedHashMap<String, String> scenarioTagData = new LinkedHashMap<String, String>();
            scenarioTagData.put(TAG, tag.getName());
            scenarioTags.add(this.createFromTemplate(this.scenarioTagTemplate, scenarioTagData));
        });
        return scenarioTags;
    }

    private String createScenarioRow(String featureId, Scenario scenario, boolean hasReruns) {
        LinkedHashMap<String, Object> scenarioData = new LinkedHashMap<String, Object>();
        String scenarioId = scenario.getCourgetteScenarioId();
        String scenarioName = scenario.getName();
        String scenarioBadge = scenario.passed() ? SUCCESS : DANGER;
        String scenarioResult = scenarioBadge.equals(SUCCESS) ? PASSED : FAILED;
        switch (scenarioBadge) {
            case "danger": {
                if (!hasReruns) break;
                scenarioResult = FAILED_AFTER_RERUN;
                break;
            }
            case "success": {
                List scenarioRunResults;
                if (!hasReruns || !(scenarioRunResults = this.courgetteRunResults.stream().filter(result -> result.getFeatureUri().equalsIgnoreCase(scenario.getFeatureUri() + ":" + scenario.getLine())).collect(Collectors.toList())).stream().anyMatch(result -> result.getStatus() == CourgetteRunResult.Status.PASSED_AFTER_RERUN)) break;
                scenarioResult = PASSED_AFTER_RERUN;
            }
        }
        scenarioData.put(DATA_TARGET, featureId);
        scenarioData.put(MODAL_TARGET, scenarioId);
        scenarioData.put(SCENARIO_NAME, scenarioName);
        scenarioData.put(SCENARIO_BADGE, scenarioBadge);
        scenarioData.put(SCENARIO_RESULT, scenarioResult);
        scenarioData.put(SCENARIO_TAGS, this.createScenarioTags(scenario));
        return this.createFromTemplate(this.scenarioTemplate, scenarioData);
    }

    private String createScenarioModal(Feature feature, Scenario scenario) {
        String featureName = feature.getUri().substring(feature.getUri().lastIndexOf("/") + 1);
        LinkedHashMap<String, Object> modalData = new LinkedHashMap<String, Object>();
        modalData.put(MODAL_TARGET, scenario.getCourgetteScenarioId());
        modalData.put(MODAL_HEADING, scenario.getName());
        modalData.put(MODAL_FEATURE_LINE, featureName + " - line " + scenario.getLine());
        ArrayList modalBody = new ArrayList();
        scenario.getBefore().forEach(hook -> modalBody.add(this.createRowFromHook((Hook)hook)));
        scenario.getSteps().forEach(step -> modalBody.add(this.createRowFromStep((Step)step)));
        scenario.getAfter().forEach(hook -> modalBody.add(this.createRowFromHook((Hook)hook)));
        modalData.put(MODAL_BODY, modalBody);
        return this.createFromTemplate(this.modalTemplate, modalData);
    }

    private String createRowFromHook(Hook hook) {
        LinkedHashMap<String, Object> hookData = new LinkedHashMap<String, Object>();
        String stepStatusBadge = statusBadge.apply(hook.getResult());
        String stepResult = statusLabel.apply(hook.getResult());
        hookData.put(STEP_NAME, hook.getLocation());
        hookData.put(STEP_DURATION, hook.getResult().getDuration());
        hookData.put(STEP_BADGE, stepStatusBadge);
        hookData.put(STEP_RESULT, stepResult);
        if (hook.getResult().getErrorMessage() != null) {
            HtmlReportBuilder.addNestedMap(hookData, STEP_EXCEPTION, EXCEPTION, hook.getResult().getErrorMessage());
        }
        if (!hook.getOutput().isEmpty()) {
            HtmlReportBuilder.addNestedMap(hookData, STEP_OUPUT, OUTPUT, hook.getOutput());
        }
        hook.getEmbeddings().forEach(embedding -> {
            if (embedding.getMimeType().equals("text/html")) {
                String htmlData = new String(Base64.getDecoder().decode(embedding.getData()));
                HtmlReportBuilder.addNestedMap(hookData, STEP_EMBEDDING_TEXT, TEXT, htmlData);
            } else if (embedding.getMimeType().startsWith("image")) {
                HtmlReportBuilder.addNestedMap(hookData, STEP_EMBEDDING_IMAGE, IMAGE_ID, embedding.getCourgetteEmbeddingId());
            }
        });
        return this.createFromTemplate(this.modalStepTemplate, hookData);
    }

    private String createRowFromStep(Step step) {
        LinkedHashMap<String, Object> stepData = new LinkedHashMap<String, Object>();
        String stepStatusBadge = statusBadge.apply(step.getResult());
        String stepResult = statusLabel.apply(step.getResult());
        stepData.put(STEP_KEYWORD, step.getKeyword());
        stepData.put(STEP_NAME, step.getName());
        stepData.put(STEP_DURATION, step.getResult().getDuration());
        stepData.put(STEP_BADGE, stepStatusBadge);
        stepData.put(STEP_RESULT, stepResult);
        if (step.getRowData() != null) {
            HtmlReportBuilder.addNestedMap(stepData, STEP_DATATABLE, DATATABLE, step.getRowData());
        }
        if (step.getResult().getErrorMessage() != null) {
            HtmlReportBuilder.addNestedMap(stepData, STEP_EXCEPTION, EXCEPTION, step.getResult().getErrorMessage());
        }
        if (!step.getOutput().isEmpty()) {
            HtmlReportBuilder.addNestedMap(stepData, STEP_OUPUT, OUTPUT, step.getOutput());
        }
        step.getEmbeddings().forEach(embedding -> {
            if (embedding.getMimeType().equals("text/html")) {
                String htmlData = new String(Base64.getDecoder().decode(embedding.getData()));
                HtmlReportBuilder.addNestedMap(stepData, STEP_EMBEDDING_TEXT, TEXT, htmlData);
            } else if (embedding.getMimeType().startsWith("image")) {
                HtmlReportBuilder.addNestedMap(stepData, STEP_EMBEDDING_IMAGE, IMAGE_ID, embedding.getCourgetteEmbeddingId());
            }
        });
        return this.createFromTemplate(this.modalStepTemplate, stepData);
    }

    private String createModalRow(String rowInfo) {
        LinkedHashMap<String, String> rowInfoData = new LinkedHashMap<String, String>();
        rowInfoData.put(ROW_INFO, rowInfo);
        return this.createFromTemplate(this.modalRowTemplate, rowInfoData);
    }

    private String createEnvironmentInfoModal() {
        String[] values;
        ArrayList<String> envData = new ArrayList<String>();
        String envInfo = this.courgetteProperties.getCourgetteOptions().environmentInfo().trim();
        for (String value : values = envInfo.split(";")) {
            String[] keyValue = value.trim().split("=");
            if (keyValue.length != 2) continue;
            envData.add(keyValue[0].trim() + " = " + keyValue[1].trim());
        }
        if (envData.isEmpty()) {
            envData.add("No additional environment information provided.");
        }
        LinkedHashMap environmentInfoData = new LinkedHashMap();
        LinkedList rowInfo = new LinkedList();
        envData.forEach(info -> rowInfo.add(this.createModalRow((String)info)));
        environmentInfoData.put(MODAL_BODY, rowInfo);
        return this.createFromTemplate(this.modalEnvironmentTemplate, environmentInfoData);
    }

    private String createFromTemplate(Mustache template, Object data) {
        StringWriter writer = new StringWriter();
        template.execute((Writer)writer, data);
        return ((Object)writer).toString();
    }

    private static void addNestedMap(HashMap<String, Object> source, String sourceKey, String childKey, Object childValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(childKey, childValue);
        source.put(sourceKey, map);
    }

    private Mustache readTemplate(String template) {
        StringBuilder templateContent = new StringBuilder();
        try {
            String line;
            InputStream in = this.getClass().getResourceAsStream(template);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                templateContent.append(line);
            }
        }
        catch (Exception e) {
            CourgetteException.printExceptionStackTrace(e);
        }
        return new DefaultMustacheFactory().compile((Reader)new StringReader(templateContent.toString()), "");
    }
}

