/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.reactor.circuitbreaker.operator.FluxCircuitBreaker;
import io.github.resilience4j.reactor.circuitbreaker.operator.MonoCircuitBreaker;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CircuitBreakerOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final CircuitBreaker circuitBreaker;

    private CircuitBreakerOperator(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public static <T> CircuitBreakerOperator<T> of(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerOperator<T>(circuitBreaker);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoCircuitBreaker((Mono)publisher, this.circuitBreaker);
        }
        if (publisher instanceof Flux) {
            return new FluxCircuitBreaker((Flux)publisher, this.circuitBreaker);
        }
        throw new IllegalStateException("Publisher of type <" + publisher.getClass().getSimpleName() + "> are not supported by this operator");
    }
}

