/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.reactor.AbstractSubscriber;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.CoreSubscriber;

class CircuitBreakerSubscriber<T>
extends AbstractSubscriber<T> {
    private final CircuitBreaker circuitBreaker;
    private final long start;
    private final boolean singleProducer;
    private final AtomicBoolean successSignaled = new AtomicBoolean(false);
    private final AtomicBoolean eventWasEmitted = new AtomicBoolean(false);

    protected CircuitBreakerSubscriber(CircuitBreaker circuitBreaker, CoreSubscriber<? super T> downstreamSubscriber, boolean singleProducer) {
        super(downstreamSubscriber);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.singleProducer = singleProducer;
        this.start = System.nanoTime();
    }

    protected void hookOnNext(T value) {
        if (!this.isDisposed()) {
            if (this.singleProducer && this.successSignaled.compareAndSet(false, true)) {
                this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            }
            this.eventWasEmitted.set(true);
            this.downstreamSubscriber.onNext(value);
        }
    }

    protected void hookOnComplete() {
        if (this.successSignaled.compareAndSet(false, true)) {
            this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
        this.downstreamSubscriber.onComplete();
    }

    public void hookOnCancel() {
        if (!this.successSignaled.get()) {
            if (this.eventWasEmitted.get()) {
                this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            } else {
                this.circuitBreaker.releasePermission();
            }
        }
    }

    protected void hookOnError(Throwable e) {
        this.circuitBreaker.onError(System.nanoTime() - this.start, TimeUnit.NANOSECONDS, e);
        this.downstreamSubscriber.onError(e);
    }
}

