/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.reactor.ratelimiter.operator.FluxRateLimiter;
import io.github.resilience4j.reactor.ratelimiter.operator.MonoRateLimiter;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RateLimiterOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final RateLimiter rateLimiter;

    private RateLimiterOperator(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoRateLimiter((Mono)publisher, this.rateLimiter);
        }
        if (publisher instanceof Flux) {
            return new FluxRateLimiter((Flux)publisher, this.rateLimiter);
        }
        throw new IllegalStateException("Publisher of type <" + publisher.getClass().getSimpleName() + "> are not supported by this operator");
    }
}

