/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.metrics.ThreadPoolBulkheadMetrics;
import io.github.resilience4j.metrics.publisher.ThreadPoolBulkheadMetricsPublisher;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class, ThreadPoolBulkhead.class, ThreadPoolBulkheadMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.thread-pool-bulkhead.metrics.enabled"}, matchIfMissing=true)
public class ThreadPoolBulkheadMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.thread-pool-bulkhead.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public ThreadPoolBulkheadMetrics registerThreadPoolBulkheadMetrics(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, MetricRegistry metricRegistry) {
        return ThreadPoolBulkheadMetrics.ofBulkheadRegistry((ThreadPoolBulkheadRegistry)threadPoolBulkheadRegistry, (MetricRegistry)metricRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.thread-pool-bulkhead.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public ThreadPoolBulkheadMetricsPublisher threadPoolBulkheadDropwizardMetricsPublisher(MetricRegistry metricRegistry) {
        return new ThreadPoolBulkheadMetricsPublisher(metricRegistry);
    }
}

