/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.metrics.CircuitBreakerMetrics;
import io.github.resilience4j.metrics.publisher.CircuitBreakerMetricsPublisher;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class, CircuitBreaker.class, CircuitBreakerMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.enabled"}, matchIfMissing=true)
public class CircuitBreakerMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public CircuitBreakerMetrics registerCircuitBreakerMetrics(CircuitBreakerRegistry circuitBreakerRegistry, MetricRegistry metricRegistry) {
        return CircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry, (MetricRegistry)metricRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public CircuitBreakerMetricsPublisher circuitBreakerMetricsPublisher(MetricRegistry metricRegistry) {
        return new CircuitBreakerMetricsPublisher(metricRegistry);
    }
}

