/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventDTOFactory;
import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"retries/"})
public class RetryEventsEndpoint {
    private final EventConsumerRegistry<RetryEvent> eventConsumerRegistry;

    public RetryEventsEndpoint(EventConsumerRegistry<RetryEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @GetMapping(value={"events"}, produces={"application/json"})
    @ResponseBody
    public RetryEventsEndpointResponse getAllRetryEvents() {
        return new RetryEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RetryEvent::getCreationTime)).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    @GetMapping(value={"events/{name}"}, produces={"application/json"})
    @ResponseBody
    public RetryEventsEndpointResponse getEventsFilteredByRetryName(@PathVariable(value="name") String name) {
        return new RetryEventsEndpointResponse(this.getRetryEvents(name).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    @GetMapping(value={"events/{name}/{eventType}"}, produces={"application/json"})
    @ResponseBody
    public RetryEventsEndpointResponse getEventsFilteredByRetryNameAndEventType(@PathVariable(value="name") String name, @PathVariable(value="eventType") String eventType) {
        return new RetryEventsEndpointResponse(this.getRetryEvents(name).filter(event -> event.getEventType() == RetryEvent.Type.valueOf((String)eventType.toUpperCase())).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    private List<RetryEvent> getRetryEvents(String name) {
        CircularEventConsumer syncEvents = this.eventConsumerRegistry.getEventConsumer(name);
        if (syncEvents != null) {
            return syncEvents.getBufferedEvents().filter(event -> event.getName().equals(name));
        }
        return List.empty();
    }
}

