/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.TimeLimiterMetrics;
import io.github.resilience4j.metrics.publisher.TimeLimiterMetricsPublisher;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class, TimeLimiter.class, TimeLimiterMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.enabled"}, matchIfMissing=true)
public class TimeLimiterMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TimeLimiterMetrics registerTimeLimiterMetrics(TimeLimiterRegistry timeLimiterRegistry, MetricRegistry metricRegistry) {
        return TimeLimiterMetrics.ofTimeLimiterRegistry((TimeLimiterRegistry)timeLimiterRegistry, (MetricRegistry)metricRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TimeLimiterMetricsPublisher timeLimiterMetricsPublisher(MetricRegistry metricRegistry) {
        return new TimeLimiterMetricsPublisher(metricRegistry);
    }
}

