/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.autoconfigure;

import io.github.resilience4j.prometheus.collectors.TimeLimiterMetricsCollector;
import io.github.resilience4j.prometheus.publisher.TimeLimiterMetricsPublisher;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.prometheus.client.GaugeMetricFamily;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GaugeMetricFamily.class, TimeLimiter.class, TimeLimiterMetricsPublisher.class})
@ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.enabled"}, matchIfMissing=true)
public class TimeLimiterPrometheusAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TimeLimiterMetricsCollector timeLimiterPrometheusCollector(TimeLimiterRegistry timeLimiterRegistry) {
        TimeLimiterMetricsCollector collector = TimeLimiterMetricsCollector.ofTimeLimiterRegistry((TimeLimiterRegistry)timeLimiterRegistry);
        collector.register();
        return collector;
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TimeLimiterMetricsPublisher timeLimiterPrometheusPublisher() {
        return new TimeLimiterMetricsPublisher();
    }
}

