/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.monitoring.endpoint;

import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventDTO;
import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import java.util.Comparator;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"timelimiter/"})
public class TimeLimiterEventsEndpoint {
    private final EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry;

    public TimeLimiterEventsEndpoint(EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @GetMapping(value={"events"}, produces={"application/json"})
    @ResponseBody
    public TimeLimiterEventsEndpointResponse getAllTimeLimiterEvents() {
        List eventsList = this.eventsConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
        return new TimeLimiterEventsEndpointResponse(eventsList);
    }

    @GetMapping(value={"events/{timeLimiterName}"}, produces={"application/json"})
    @ResponseBody
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterName(@PathVariable(value="timeLimiterName") String timeLimiterName) {
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(timeLimiterName).getBufferedEvents().filter(event -> event.getTimeLimiterName().equals(timeLimiterName)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
        return new TimeLimiterEventsEndpointResponse(eventsList);
    }

    @GetMapping(value={"events/{timeLimiterName}/{eventType}"}, produces={"application/json"})
    @ResponseBody
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterNameAndEventType(@PathVariable(value="timeLimiterName") String timeLimiterName, @PathVariable(value="eventType") String eventType) {
        TimeLimiterEvent.Type targetType = TimeLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(timeLimiterName).getBufferedEvents().filter(event -> event.getTimeLimiterName().equals(timeLimiterName)).filter(event -> event.getEventType() == targetType).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
        return new TimeLimiterEventsEndpointResponse(eventsList);
    }
}

