/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.rockit.common.blackboxtester.assertions.AbstractAssertion;
import com.rockit.common.blackboxtester.exceptions.AssertionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class CSVFileAssertion
extends AbstractAssertion {
    public static final Logger LOGGER = Logger.getLogger((String)CSVFileAssertion.class.getName());
    private String separator;
    private List<Integer> ignoreIndexes = new ArrayList<Integer>();

    private CSVFileAssertion() {
    }

    public CSVFileAssertion(String step) {
        this.relPath = File.separator + step;
    }

    public CSVFileAssertion(String step, String connector) {
        this.relPath = File.separator + step + File.separator + connector;
    }

    @Override
    public void proceed() {
        File recordFolder = new File(this.recordPath + this.getRelPath());
        File replayFolder = new File(this.replayPath + this.getRelPath());
        for (File recordFile : Files.fileTraverser().depthFirstPreOrder((Object)recordFolder)) {
            String relativePath = recordFolder.toURI().relativize(recordFile.toURI()).getPath();
            File replayFile = new File(replayFolder + "/" + relativePath);
            LOGGER.debug((Object)("asserting: source " + recordFile.getAbsolutePath() + " with target " + replayFile.getAbsolutePath()));
            try {
                if (recordFile.isDirectory() || replayFile.isDirectory()) continue;
                this.csvAssert(recordFile, replayFile);
            }
            catch (AssertionError e) {
                throw new AssertionException(" csv files doesn't match each other " + replayFile.getAbsolutePath() + " / " + recordFile.getAbsolutePath(), e);
            }
        }
    }

    void csvAssert(File f1, File f2) {
        Assert.assertTrue((String)(f1.getAbsolutePath() + " not exists"), (boolean)f1.exists());
        Assert.assertTrue((String)(f2.getAbsolutePath() + " not exists"), (boolean)f2.exists());
        try {
            Set<String> f1Lines = new HashSet<String>(FileUtils.readLines((File)f1));
            Set<String> ff1Lines = new HashSet<String>(f1Lines);
            Set<String> f2Lines = new HashSet<String>(FileUtils.readLines((File)f2));
            Set<String> ff2Lines = new HashSet<String>(f2Lines);
            if (this.separator != null && this.ignoreIndexes != null && !this.ignoreIndexes.isEmpty()) {
                f1Lines = this.removeIgnored(f1Lines);
                ff1Lines = this.removeIgnored(ff1Lines);
                f2Lines = this.removeIgnored(f2Lines);
                ff2Lines = this.removeIgnored(ff2Lines);
            }
            f1Lines.removeAll(ff2Lines);
            f2Lines.removeAll(ff1Lines);
            Assert.assertTrue((String)("\n " + f1.getAbsolutePath() + " diff: \n " + Joiner.on((String)"\n").join(f1Lines) + "\n-----------------\n" + f2.getAbsolutePath() + " diff: \n " + Joiner.on((String)"\n").join(f2Lines)), (f2Lines.isEmpty() && f1Lines.isEmpty() ? 1 : 0) != 0);
        }
        catch (IOException e) {
            LOGGER.error((Object)("asserting: " + f1.getAbsolutePath() + " with target " + f2.getAbsolutePath()), (Throwable)e);
            throw new AssertionError("asserting: " + f1.getAbsolutePath() + " with target " + f2.getAbsolutePath(), e);
        }
    }

    Set<String> removeIgnored(Set<String> lines) {
        HashSet<String> rs = new HashSet<String>();
        lines.forEach(l -> {
            String res = "";
            int i = 0;
            for (String t : l.split(this.separator)) {
                if (!this.ignoreIndexes.contains(i)) {
                    res = res + t + this.separator;
                }
                ++i;
            }
            rs.add(res);
        });
        return rs;
    }

    public CSVFileAssertion setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public CSVFileAssertion setIgnoreIndexes(List<Integer> ignoreIndexes) {
        this.ignoreIndexes = ignoreIndexes;
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "( path:\"" + (this.relPath.equalsIgnoreCase("") ? "\\" : this.relPath) + "\"" + (this.separator != null && !this.separator.isEmpty() ? ", separator:\"" + this.separator + "\"" : "") + (null != this.ignoreIndexes && !this.ignoreIndexes.isEmpty() ? ", ignoreIndexes:\"" + Joiner.on((String)",").join(this.ignoreIndexes) + "\"" : "") + " )";
    }
}

