/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.base.Joiner;
import com.rockit.common.blackboxtester.assertions.AbstractAssertion;
import com.rockit.common.blackboxtester.exceptions.AssertionException;
import com.rockit.common.blackboxtester.exceptions.GenericException;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.DBDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class DBAssertion
extends AbstractAssertion {
    public static final Logger LOGGER = Logger.getLogger((String)DBAssertion.class.getName());
    private List<String> mustContainTokens;
    private String refDsId;
    private String sql;
    private Connection connection;

    public DBAssertion(String sqlQuery, List<String> mustContainTokens) {
        this("defaultDB", sqlQuery, mustContainTokens);
    }

    public DBAssertion(String datasourceId, String sqlQuery, List<String> mustContainTokens) {
        this.refDsId = datasourceId;
        this.mustContainTokens = mustContainTokens;
        this.sql = sqlQuery;
    }

    @Override
    public void proceed() {
        String result = this.executeSql();
        LOGGER.info((Object)("sql: " + this.sql + "\n result: \n  " + result));
        for (String token : this.mustContainTokens) {
            try {
                Assert.assertTrue((String)("mustContainTokens: " + token + " must be in result"), (boolean)result.contains(token));
            }
            catch (AssertionError e) {
                throw new AssertionException(e);
            }
        }
    }

    private String executeSql() {
        StringBuilder resultBuilder = new StringBuilder();
        this.createDatabaseConnection();
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery(this.sql);){
            int i;
            ResultSetMetaData md = rs.getMetaData();
            int cols = md.getColumnCount();
            for (i = 0; i < cols; ++i) {
                resultBuilder.append(md.getColumnLabel(i + 1) + "\t");
            }
            while (rs.next()) {
                for (i = 0; i < cols; ++i) {
                    String value = rs.getString(i + 1);
                    resultBuilder.append(value + "\t");
                }
                resultBuilder.append("\n");
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Database access error: ", (Throwable)e);
            throw new GenericException(e);
        }
        return resultBuilder.toString();
    }

    private void createDatabaseConnection() {
        DBConnectorCfg dummy = new DBConnectorCfg();
        dummy.setDsRefId(this.refDsId);
        DBDataSource ds = Configuration.configuration().getDBDataSourceByConnector(dummy);
        String url = ds.getUrl();
        String user = ds.getUser();
        String password = ds.getPassword();
        try {
            Class.forName(url.contains("db2") ? "com.ibm.db2.jcc.DB2Driver" : "oracle.jdbc.driver.OracleDriver").newInstance();
            this.connection = DriverManager.getConnection(url, user, password);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            LOGGER.error((Object)("DB Connection cannot be instantiated. \nurl:" + url + ", user:" + user + ", password:" + password), (Throwable)e);
            throw new GenericException(e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ", datasourceId:\"" + (this.refDsId != null && !this.refDsId.isEmpty() ? this.refDsId : "") + ", sqlQuery:\"" + (this.sql != null && !this.sql.isEmpty() ? this.sql : "") + (null != this.mustContainTokens && !this.mustContainTokens.isEmpty() ? ", assertContainsTokens:\"" + Joiner.on((String)",").useForNull("").join(this.mustContainTokens) + "\"" : "") + " )";
    }
}

