/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.io.Files;
import com.rockit.common.blackboxtester.assertions.AbstractAssertion;
import com.rockit.common.blackboxtester.exceptions.AssertionException;
import java.io.File;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class FileAssertion
extends AbstractAssertion {
    public static final Logger LOGGER = Logger.getLogger((String)FileAssertion.class.getName());

    public FileAssertion(String recordPath, String replayPath) {
        this.setRecordPath(recordPath);
        this.setReplayPath(replayPath);
    }

    @Override
    public void proceed() {
        File recordFolder = new File(this.recordPath);
        File replayFolder = new File(this.replayPath);
        for (File recordFile : Files.fileTraverser().depthFirstPreOrder((Object)recordFolder)) {
            String relativePath = recordFolder.toURI().relativize(recordFile.toURI()).getPath();
            File replayFile = new File(replayFolder + "/" + relativePath);
            if (replayFile.getName().equalsIgnoreCase(".gitignore") || recordFile.getName().equalsIgnoreCase(".gitignore")) continue;
            LOGGER.debug((Object)("asserting: source " + recordFile.getAbsolutePath() + " with target " + replayFile.getAbsolutePath()));
            try {
                Assert.assertTrue((String)(" matching file " + replayFile.getAbsolutePath() + " must exist"), (replayFile.exists() ? 1 : 0) != 0);
            }
            catch (AssertionError e) {
                throw new AssertionException(" matching file " + replayFile.getAbsolutePath() + " must exist ", e);
            }
        }
    }
}

