/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.io.Files;
import com.rockit.common.blackboxtester.assertions.AbstractAssertion;
import com.rockit.common.blackboxtester.assertions.FileAssertion;
import com.rockit.common.blackboxtester.assertions.fixedlength.DifferenceBuilder;
import com.rockit.common.blackboxtester.assertions.fixedlength.RecordConfig;
import com.rockit.common.blackboxtester.assertions.fixedlength.RecordsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class FixedLengthFileAssertion
extends AbstractAssertion {
    protected List<String> recorded = new ArrayList<String>();
    protected List<String> replayed = new ArrayList<String>();
    private RecordConfig recordConfig = null;
    private final DifferenceBuilder db = new DifferenceBuilder(this);

    public FixedLengthFileAssertion(String step, String connector, String config) {
        this.recordConfig = RecordsConfig.getInstance().getRecordConfig(config);
        this.relPath = File.separator + step + File.separator + connector;
    }

    public FixedLengthFileAssertion(String step, String config) {
        this.recordConfig = RecordsConfig.getInstance().getRecordConfig(config);
        this.relPath = File.separator + step;
    }

    @Override
    public void proceed() {
        File recordFolder = new File(this.recordPath + this.getRelPath());
        File replayFolder = new File(this.replayPath + this.getRelPath());
        for (File recordFile : Files.fileTraverser().depthFirstPreOrder((Object)recordFolder)) {
            if (!recordFile.isFile()) continue;
            String relativePath = recordFolder.toURI().relativize(recordFile.toURI()).getPath();
            String replayFilePath = replayFolder + File.separator + relativePath;
            this.recorded = FixedLengthFileAssertion.fileToLineList(recordFile.getAbsolutePath());
            this.replayed = FixedLengthFileAssertion.fileToLineList(replayFilePath);
            this.db.build(recordFile.getName());
            FileAssertion.LOGGER.debug((Object)("fixedlength recorded content " + recordFile.getPath() + " with replayed " + replayFilePath));
        }
        this.db.doAssert();
    }

    protected static List<String> fileToLineList(String filePath) {
        File fileToExtract = new File(filePath);
        ArrayList<String> lineList = new ArrayList<String>();
        if (fileToExtract.isFile()) {
            try (Scanner sc = new Scanner(fileToExtract);){
                while (sc.hasNextLine()) {
                    lineList.add(sc.nextLine());
                }
            }
            catch (Exception e) {
                FileAssertion.LOGGER.error((Object)"Error occured: ", (Throwable)e);
            }
        }
        return lineList;
    }

    public List<String> getRecorded() {
        return this.recorded;
    }

    public List<String> getReplayed() {
        return this.replayed;
    }

    public RecordConfig getRecordConfig() {
        return this.recordConfig;
    }
}

