/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.rockit.common.blackboxtester.assertions.XMLFileAssertion;
import com.rockit.common.blackboxtester.exceptions.AssertionException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.json.XML;
import org.xmlunit.builder.Input;

public class JSONFileAssertion
extends XMLFileAssertion {
    public static final Logger LOGGER = Logger.getLogger((String)JSONFileAssertion.class.getName());

    public JSONFileAssertion(String step) {
        super(step);
    }

    public JSONFileAssertion(String step, String connector) {
        super(step, connector);
    }

    @Override
    public void proceed() {
        File recordFolder = new File(this.recordPath + this.getRelPath());
        File replayFolder = new File(this.replayPath + this.getRelPath());
        for (File recordFile : Files.fileTraverser().depthFirstPreOrder((Object)recordFolder)) {
            String relativePath = recordFolder.toURI().relativize(recordFile.toURI()).getPath();
            File replayFile = new File(replayFolder + File.separator + relativePath);
            if (!recordFile.isFile() || !replayFile.isFile()) continue;
            LOGGER.debug((Object)("jsonasserting " + recordFile.getPath() + " with " + replayFile.getPath()));
            try {
                this.compare(Input.fromString((String)this.jsonToXMLFile(recordFile)), Input.fromString((String)this.jsonToXMLFile(replayFile))).build();
            }
            catch (AssertionError e) {
                throw new AssertionException(JSONFileAssertion.class.getSimpleName() + ":" + relativePath, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    String jsonToXMLFile(File recordFile) throws IOException {
        List lines = Files.readLines((File)recordFile, (Charset)Charset.defaultCharset());
        JSONObject json = new JSONObject(Joiner.on((String)"").join((Iterable)lines));
        String xml = XML.toString((Object)json);
        return "<root>" + xml + "</root>";
    }
}

