/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.rockit.common.blackboxtester.assertions.AbstractAssertion;
import com.rockit.common.blackboxtester.exceptions.AssertionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.util.Predicate;

public class XMLFileAssertion
extends AbstractAssertion {
    public static final Logger LOGGER = Logger.getLogger((String)XMLFileAssertion.class.getName());
    private List<String> tokens = new ArrayList<String>();
    private List<String> attrs = new ArrayList<String>();
    private DiffBuilder diffBuilder;
    BuilderContext context = new BuilderContext();

    private XMLFileAssertion() {
    }

    public XMLFileAssertion(String step) {
        this.relPath = File.separator + step;
    }

    public XMLFileAssertion(String step, String connector) {
        this.relPath = File.separator + step + File.separator + connector;
    }

    @Override
    public void proceed() {
        File recordFolder = new File(this.recordPath + this.relPath);
        File replayFolder = new File(this.replayPath + this.relPath);
        for (File recordFile : Files.fileTraverser().depthFirstPreOrder((Object)recordFolder)) {
            String relativePath = recordFolder.toURI().relativize(recordFile.toURI()).getPath();
            File replayFile = new File(replayFolder + File.separator + relativePath);
            if (!recordFile.isFile() || !replayFile.isFile()) continue;
            LOGGER.debug((Object)("xmlasserting " + recordFile.getPath() + " with " + replayFile.getPath()));
            try {
                this.compare(Input.fromFile((File)recordFile), Input.fromFile((File)replayFile)).build();
            }
            catch (AssertionError e) {
                throw new AssertionException(XMLFileAssertion.class.getSimpleName() + ":" + this.relPath + "/" + relativePath, e);
            }
        }
    }

    public XMLFileAssertion ignoreAttrs(List<String> attrs) {
        this.attrs = attrs;
        return this;
    }

    public XMLFileAssertion ignore(List<String> tokens) {
        this.tokens = tokens;
        return this;
    }

    protected XMLFileAssertion build() {
        Diff diff = this.diffBuilder.normalizeWhitespace().build();
        Assert.assertFalse((String)diff.getDifferences().toString(), (boolean)diff.hasDifferences());
        return this;
    }

    public XMLFileAssertion ignoreWhitespaces() {
        this.context.ignoreWhitespaces = true;
        return this;
    }

    public XMLFileAssertion withNodeMatcher(ElementSelector selector) {
        this.context.selector = selector;
        return this;
    }

    public XMLFileAssertion checkForSimilar() {
        this.context.checkForSimilar = true;
        return this;
    }

    public XMLFileAssertion checkForIdentical() {
        this.context.checkForIdentical = true;
        return this;
    }

    protected XMLFileAssertion compare(Input.Builder in1, Input.Builder in2) {
        this.diffBuilder = DiffBuilder.compare((Object)in1).withTest((Object)in2).withNodeFilter((Predicate)new Predicate<Node>(){

            public boolean test(Node node) {
                LOGGER.trace((Object)("current node " + node.getNodeName() + " result " + String.valueOf(!XMLFileAssertion.this.tokens.contains(node.getNodeName()))));
                return !XMLFileAssertion.this.tokens.contains(node.getNodeName());
            }
        }).withAttributeFilter((Predicate)new Predicate<Attr>(){

            public boolean test(Attr a) {
                LOGGER.trace((Object)("current attr " + a.getName() + " result " + String.valueOf(!XMLFileAssertion.this.attrs.contains(a.getName()))));
                return !XMLFileAssertion.this.attrs.contains(a.getName());
            }
        });
        if (this.context.ignoreWhitespaces) {
            this.diffBuilder.ignoreWhitespace();
        }
        if (this.context.checkForIdentical) {
            this.diffBuilder.checkForIdentical();
        }
        if (this.context.checkForSimilar) {
            this.diffBuilder.checkForSimilar();
        }
        if (this.context.selector != null) {
            this.diffBuilder.withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{this.context.selector}));
        }
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "( path:\"" + (this.relPath.equalsIgnoreCase("") ? "\\" : this.relPath) + "\"" + (null != this.tokens && !this.tokens.isEmpty() ? ", ignoreFields:\"" + Joiner.on((String)",").join(this.tokens) + "\"" : "") + (null != this.attrs && this.attrs.isEmpty() ? ", ignoreAttrs:\"" + Joiner.on((String)",").join(this.attrs) + "\"" : "") + " )";
    }

    private class BuilderContext {
        private boolean ignoreWhitespaces;
        private boolean checkForIdentical;
        private boolean checkForSimilar;
        private ElementSelector selector;

        private BuilderContext() {
        }
    }
}

