/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.assertions.fixedlength;

import com.rockit.common.blackboxtester.assertions.FixedLengthFileAssertion;
import com.rockit.common.blackboxtester.assertions.fixedlength.RecordConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;

public class DifferenceBuilder {
    private final List<String> actualDifferences = new ArrayList<String>();
    private final FixedLengthFileAssertion fa;
    private String fileName;

    public DifferenceBuilder(FixedLengthFileAssertion fa) {
        this.fa = fa;
    }

    private void doLineDiff(int linePosition, String recorded, String replayed) {
        if (recorded.length() == 0 || replayed.length() == 0) {
            this.add(recorded, replayed, linePosition, 99999);
        } else {
            List<String> recordedTokenized = this.parse(recorded, this.fa.getRecordConfig(), true);
            List<String> replayedTokenized = this.parse(replayed, this.fa.getRecordConfig(), false);
            for (int tokenInLine = 0; tokenInLine < recordedTokenized.size(); ++tokenInLine) {
                if (!this.fa.getRecordConfig().doDiff(tokenInLine) || recordedTokenized.get(tokenInLine).equalsIgnoreCase(replayedTokenized.get(tokenInLine))) continue;
                this.add(recordedTokenized.get(tokenInLine), replayedTokenized.get(tokenInLine), linePosition, tokenInLine);
            }
        }
    }

    public void build(String fileName) {
        this.fileName = fileName;
        Iterator<String> replayed = this.fa.getReplayed().iterator();
        Iterator<String> recorded = this.fa.getRecorded().iterator();
        int linePosition = 1;
        while (replayed.hasNext() || recorded.hasNext()) {
            String recordedLine = recorded.hasNext() ? recorded.next() : "";
            String replayedLine = replayed.hasNext() ? replayed.next() : "";
            this.doLineDiff(linePosition, recordedLine, replayedLine);
            ++linePosition;
        }
    }

    private List<String> parse(String lineToParse, RecordConfig rc, boolean isRecorded) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < rc.getTokenCount(); ++i) {
            try {
                result.add(lineToParse.substring(rc.getStart(i), rc.getEnd(i)));
                continue;
            }
            catch (StringIndexOutOfBoundsException stob) {
                StringBuilder sb = new StringBuilder("");
                if (isRecorded) {
                    sb.append("Expected");
                } else {
                    sb.append("Received");
                }
                sb.append(" content of length: ");
                sb.append(rc.getEnd(i) - rc.getStart(i)).append(" but was: ");
                String content = lineToParse.length() >= rc.getStart(i) ? lineToParse.substring(rc.getStart(i), lineToParse.length()) : "\"\"";
                sb.append(content);
                result.add(sb.toString());
            }
        }
        return result;
    }

    private void add(String expected, String actual, int linePos, int tokenPosition) {
        StringBuilder sb = new StringBuilder("[Error in file: ").append(this.fileName).append(" at line: ");
        sb.append(linePos).append(" at pos ").append(tokenPosition + 1).append(" expected: ").append(expected).append(" vs. actual: ").append(actual).append("]\n");
        this.actualDifferences.add(sb.toString());
    }

    private String formatDifferences() {
        StringBuilder sb = new StringBuilder("");
        if (this.actualDifferences.size() > 0) {
            sb.append("During compare ").append(this.actualDifferences.size()).append(" errors detected!");
            sb.append(System.lineSeparator());
            Iterator<String> ad = this.actualDifferences.iterator();
            while (ad.hasNext()) {
                sb.append(ad.next());
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public void doAssert() {
        Assert.assertEquals((Object)"", (Object)this.formatDifferences());
    }
}

