/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.google.common.base.Strings;
import com.rockit.common.blackboxtester.connector.ReadConnector;
import com.rockit.common.blackboxtester.connector.impl.db.DatabaseConnection;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBGetConnector
extends DatabaseConnection
implements ReadConnector {
    public static final Logger LOGGER = Logger.getLogger((String)DBGetConnector.class.getName());
    private String id;
    private StringBuilder resultBuilder;
    private String sqlQuery;

    public DBGetConnector(String id) {
        super(id);
        DBConnectorCfg dbConCfg = (DBConnectorCfg)Configuration.configuration().getConnectorById(id);
        this.id = id;
        this.sqlQuery = dbConCfg.getQuery();
    }

    private String executeSql() {
        StringBuffer writer = new StringBuffer().append("<ROOT>").append(System.lineSeparator());
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.sqlQuery);){
            ResultSetMetaData metaData = rs.getMetaData();
            int colCount = metaData.getColumnCount();
            while (rs.next()) {
                writer.append("<").append("ROW").append(">");
                for (int i = 1; i <= colCount; ++i) {
                    String col = metaData.getColumnLabel(i);
                    String value = rs.getString(i);
                    writer.append("<").append(col).append(">");
                    writer.append(Strings.nullToEmpty((String)value).trim());
                    writer.append("</").append(col).append(">");
                }
                writer.append("</").append("ROW").append(">").append(System.lineSeparator());
            }
        }
        catch (SQLException e) {
            throw new ConnectorException("can not execute query: " + this.sqlQuery, e);
        }
        writer.append("</ROOT>");
        return writer.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getResponse() {
        return this.resultBuilder.toString();
    }

    @Override
    public String getType() {
        return Constants.Connectors.DBGET.toString();
    }

    @Override
    public void proceed() {
        this.createDatabaseConnection();
        this.setReponse(this.executeSql());
    }

    @Override
    public void setReponse(String response) {
        this.resultBuilder = new StringBuilder(response);
    }
}

