/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.google.common.base.Splitter;
import com.rockit.common.blackboxtester.connector.WriteConnector;
import com.rockit.common.blackboxtester.connector.impl.db.DatabaseConnection;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import com.rockit.common.blackboxtester.suite.configuration.PayloadReplacer;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DBPutConnector
extends DatabaseConnection
implements WriteConnector {
    public static final Logger LOGGER = Logger.getLogger((String)DBPutConnector.class.getName());
    private static final String DELIMITER = ";";
    static final String LINE_SEPARATOR = "###";
    private String id;
    private File file;

    public DBPutConnector(String id) {
        super(id);
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return Constants.Connectors.DBPUT.toString();
    }

    @Override
    public void proceed() {
        this.createDatabaseConnection();
        this.runScript();
    }

    private void runScript() {
        List<String> commandsList = this.extractSQLCommandsFromPayload();
        for (String cmd : commandsList) {
            cmd = cmd.replaceAll(LINE_SEPARATOR, " ");
            LOGGER.debug((Object)cmd);
            try {
                Statement statement = this.connection.createStatement();
                Throwable throwable = null;
                try {
                    statement.execute(cmd);
                    this.connection.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new ConnectorException("Error for cmd: " + cmd, e);
            }
        }
    }

    List<String> extractSQLCommandsFromPayload() {
        StringBuilder commands = new StringBuilder();
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.file.getAbsolutePath(), new String[0]), Charset.defaultCharset());
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.startsWith("--")) continue;
                commands.append(line.trim()).append(LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new ConnectorException("Error for reading payload file: " + this.file.getAbsolutePath(), e);
        }
        List commandsList = Splitter.on((String)";###").trimResults().omitEmptyStrings().splitToList((CharSequence)commands);
        return commandsList;
    }

    @Override
    public void setRequest(File requestFile) {
        this.file = PayloadReplacer.interpolate(requestFile, Configuration.configuration().getPayloadReplacements());
    }

    @Override
    public void setRequest(String request) {
        throw new ConnectorException("[Connector:" + this.getId() + "] \t Set method is not allowed");
    }
}

