/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.rockit.common.blackboxtester.connector.Connector;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;

public class FileDelConnector
implements Connector {
    private String id;
    private String srcPath;

    public FileDelConnector(String id) {
        this.id = id;
        FileConnectorCfg cfg = (FileConnectorCfg)Configuration.configuration().getConnectorById(id);
        this.srcPath = cfg.getPath();
    }

    @Override
    public void proceed() {
        try {
            File f = new File(this.srcPath);
            FileUtils.deleteFilesRecursive(f);
        }
        catch (Exception e) {
            throw new ConnectorException("[Connector:" + this.getId() + "] \t Connector error: " + this.getType(), e);
        }
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Override
    public String getType() {
        return Constants.Connectors.FILEDEL.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }
}

