/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.google.common.io.Files;
import com.rockit.common.blackboxtester.connector.ReadConnector;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import java.nio.charset.Charset;

public class FileGetConnector
implements ReadConnector {
    private String id;
    private String srcPath;
    private String response;

    public FileGetConnector(String id) {
        this.id = id;
        FileConnectorCfg cfg = (FileConnectorCfg)Configuration.configuration().getConnectorById(id);
        this.srcPath = cfg.getPath();
    }

    @Override
    public void proceed() {
        try {
            File f = new File(this.srcPath);
            if (f.isDirectory()) {
                f = FileUtils.lastFile(f);
            }
            this.response = Files.asCharSource((File)f, (Charset)Charset.defaultCharset()).read();
        }
        catch (Exception e) {
            throw new ConnectorException("[Connector:" + this.getId() + "] \t Connector error: " + this.getType(), e);
        }
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    @Override
    public String getType() {
        return Constants.Connectors.FILEGET.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getResponse() {
        return this.response;
    }

    @Override
    public void setReponse(String response) {
        throw new ConnectorException("[Connector:" + this.getId() + "] \t Set method is not allowed");
    }
}

