/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.rockit.common.blackboxtester.connector.WriteConnector;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import com.rockit.common.blackboxtester.suite.configuration.PayloadReplacer;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;

public class FilePutConnector
implements WriteConnector {
    private String id;
    private String destPath;
    private File contentFile;

    public FilePutConnector(String id) {
        this.id = id;
        FileConnectorCfg cfg = (FileConnectorCfg)Configuration.configuration().getConnectorById(id);
        this.destPath = cfg.getPath();
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Override
    public void proceed() {
        try {
            FileUtils.copy(this.contentFile, new File(this.destPath));
        }
        catch (Exception e) {
            throw new ConnectorException("[Connector:" + this.getId() + "] \t Connector error: " + this.getType(), e);
        }
    }

    @Override
    public String getType() {
        return Constants.Connectors.FILEPUT.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setRequest(File requestFile) {
        this.contentFile = PayloadReplacer.interpolate(requestFile, Configuration.configuration().getPayloadReplacements());
    }

    @Override
    public void setRequest(String request) {
        throw new ConnectorException("[Connector:" + this.getId() + "] \t Set method is not allowed");
    }

    public String getDestPath() {
        return this.destPath;
    }
}

