/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.google.common.io.Files;
import com.rockit.common.blackboxtester.connector.ReadConnector;
import com.rockit.common.blackboxtester.connector.WriteConnector;
import com.rockit.common.blackboxtester.connector.impl.http.ResponseHeader;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import com.rockit.common.blackboxtester.suite.configuration.PayloadReplacer;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.HTTPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.KeyStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class HTTPConnector
implements ReadConnector,
WriteConnector {
    public static final Logger LOGGER = Logger.getLogger((String)HTTPConnector.class.getName());
    private StringBuilder resultBuilder;
    private String id;
    private String urlStr;
    private String method;
    private String trustStore;
    private Map<String, String> headers = new HashMap<String, String>();
    private Integer connectTimeOut;
    private URL url;
    private File file;

    HTTPConnector(HTTPConnectorCfg cfg) {
        this.id = cfg.getId();
        this.urlStr = cfg.getUrl();
        this.method = cfg.getMethod();
        this.connectTimeOut = Integer.valueOf(cfg.getTimeout());
        this.headers = cfg.getHeaders();
        KeyStore ks = Configuration.configuration().getKeyStoreByConnector(cfg);
        if (ks != null) {
            this.trustStore = ks.getPath();
        }
    }

    public HTTPConnector(String id) {
        this((HTTPConnectorCfg)Configuration.configuration().getConnectorById(id));
    }

    @Override
    public void proceed() {
        String result = null;
        HttpURLConnection urlConnection = null;
        try {
            InputStream is;
            this.url = new URL(this.urlStr);
            if (this.trustStore != null) {
                System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            }
            System.setProperty("javax.net.ssl.trustStoreType", "jks");
            urlConnection = this.urlStr.startsWith("https://") ? (HttpsURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection();
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                urlConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            urlConnection.setRequestMethod(this.method);
            if (!this.method.equalsIgnoreCase("GET")) {
                urlConnection.setDoOutput(true);
            }
            if (this.connectTimeOut > 0) {
                urlConnection.setConnectTimeout(this.connectTimeOut);
            }
            this.enhanceBasicAuthentication(urlConnection);
            if (urlConnection.getDoOutput()) {
                this.enhancePayload(urlConnection);
            }
            try {
                is = urlConnection.getInputStream();
            }
            catch (UnknownHostException uhe) {
                throw new ConnectorException(uhe);
            }
            catch (IOException e) {
                is = urlConnection.getErrorStream();
            }
            result = IOUtils.toString((InputStream)is);
            if (urlConnection.getRequestProperty("Content-Type") != null && urlConnection.getRequestProperty("Content-Type").equalsIgnoreCase("application/xml")) {
                this.setReponse(result);
            } else {
                if (!this.isJSONStringValid(result)) {
                    throw new ConnectorException("Invalid JSON: " + result);
                }
                Map<String, List<String>> map = urlConnection.getHeaderFields();
                ResponseHeader newResonseHeader = new ResponseHeader(map);
                JSONObject responseHeader = newResonseHeader.getResponsHeader();
                String responseString = this.buildJSONResponseString(responseHeader.toString().replace("null", "Code"), result);
                if (!this.isJSONStringValid(responseString)) {
                    throw new ConnectorException("Invalid JSON: " + responseString);
                }
                this.setReponse(responseString);
            }
        }
        catch (IOException e) {
            throw new ConnectorException("can not open connection: " + this.url, e);
        }
        catch (JSONException je) {
            throw new ConnectorException("JSON deserialization Exception.", je);
        }
        finally {
            try {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isJSONStringValid(String result) {
        try {
            new JSONObject(result);
        }
        catch (JSONException je) {
            try {
                new JSONArray(result);
            }
            catch (JSONException jex) {
                LOGGER.warn((Object)("Invalid JSON: " + result));
                return false;
            }
        }
        return true;
    }

    public String buildJSONResponseString(String responseHeader, String responseBody) {
        StringBuilder responseString = new StringBuilder();
        responseString.append("{\"response\":{");
        responseString.append("\"header\":");
        responseString.append(responseHeader);
        responseString.append(",\"body\":");
        responseString.append(responseBody);
        responseString.append("}}");
        return responseString.toString();
    }

    private JSONArray getJsonArrayBody(String result) throws IOException {
        JSONObject jsonObject = null;
        try {
            JSONObject myJsonObject = new JSONObject(result);
            JSONArray newJsonArray = new JSONArray();
            newJsonArray.put((Object)myJsonObject);
            return newJsonArray;
        }
        catch (JSONException je) {
            try {
                JSONArray newJsonArray = new JSONArray(result);
                return newJsonArray;
            }
            catch (JSONException e) {
                jsonObject = XML.toJSONObject((String)result);
                JSONArray newJsonArray = new JSONArray((Object)jsonObject);
                return newJsonArray;
            }
        }
    }

    private void enhancePayload(HttpURLConnection urlConnection) throws UnsupportedEncodingException, IOException {
        if (this.file != null) {
            OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");
            writer.write(Files.asCharSource((File)this.file, (Charset)Charset.defaultCharset()).read());
            writer.close();
        }
    }

    private void enhanceBasicAuthentication(HttpURLConnection urlConnection) {
        if (this.url.getUserInfo() != null && this.url.getUserInfo().split(":").length == 2) {
            LOGGER.debug((Object)("Basic authentication usr/pwd >   " + this.url.getUserInfo()));
            String name = this.url.getUserInfo().split(":")[0];
            String password = this.url.getUserInfo().split(":")[1];
            byte[] authEncBytes = Base64.getEncoder().encode((name + ":" + password).getBytes());
            urlConnection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return Constants.Connectors.HTTP.toString();
    }

    @Override
    public String getResponse() {
        return this.resultBuilder.toString();
    }

    @Override
    public void setReponse(String response) {
        this.resultBuilder = new StringBuilder(response);
    }

    @Override
    public void setRequest(File requestFile) {
        this.file = PayloadReplacer.interpolate(requestFile, Configuration.configuration().getPayloadReplacements());
    }

    @Override
    public void setRequest(String request) {
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }
}

