/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.google.common.base.Strings;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.headers.MQDataException;
import com.rockit.common.blackboxtester.connector.impl.MQPayloadBuilder;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.MQConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.MQDataSource;
import io.github.rockitconsulting.test.rockitizer.payload.model.MqPayload;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MQAccessor {
    public static final Logger LOGGER = Logger.getLogger((String)MQAccessor.class.getName());
    static Map<String, MQQueueManager> cache = new HashMap<String, MQQueueManager>();
    protected String qManager;
    protected String qName;
    protected byte[] message;
    protected String messageId;
    protected String channelname;
    protected int port;
    protected String hostname;
    private final QueueOption qOption;
    private HashMap<String, Object> mqEnv;
    private MQConnectorCfg conCfg;

    public MQAccessor(String id) {
        this.conCfg = (MQConnectorCfg)Configuration.configuration().getConnectorById(id);
        MQDataSource ds = Configuration.configuration().getMQDataSourceByConnector(this.conCfg);
        this.mqEnv = new HashMap();
        this.mqEnv.put("Use MQCSP authentication", false);
        this.mqEnv.put("channel", ds.getChannel());
        this.mqEnv.put("hostname", ds.getHost());
        this.mqEnv.put("port", new Integer(ds.getPort()));
        if (!Strings.isNullOrEmpty((String)ds.getUser()) && !Strings.isNullOrEmpty((String)ds.getPassword())) {
            this.mqEnv.put("Use MQCSP authentication", true);
            this.mqEnv.put("userID", ds.getUser());
            this.mqEnv.put("password", ds.getPassword());
        }
        this.port = Integer.valueOf(ds.getPort());
        this.hostname = ds.getHost();
        this.channelname = ds.getChannel();
        this.qManager = ds.getQmgr();
        this.qName = this.conCfg.getQueue();
        this.qOption = QueueOption.GenerateMsgId;
    }

    public String get() {
        try {
            MQQueueManager qMgr = this.newMQQueueManager();
            int openOptions = 8226;
            MQQueue queue = qMgr.accessQueue(this.qName, 8226);
            MQMessage msg = new MQMessage();
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options = 0x2000000;
            if (queue.getCurrentDepth() < 1) {
                return null;
            }
            queue.get(msg, gmo);
            MqPayload payload = MQPayloadBuilder.newPayload(msg);
            if (queue.isOpen()) {
                queue.close();
            }
            return MQPayloadBuilder.toXmlString(payload);
        }
        catch (MQException | MQDataException | IOException e) {
            throw new ConnectorException("Can not read queue: " + this.qName, e);
        }
    }

    private void write(MQQueue queue, String name, byte[] message) {
        try {
            MQMessage mQMsg = MQPayloadBuilder.newMqMessageFromXMLString(message);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            switch (this.qOption) {
                case SetMsgId: {
                    pmo.options |= 0x800;
                    break;
                }
                case SetMsgIdAndUserId: {
                    pmo.options |= 0x400;
                    mQMsg.userId = "unknown";
                }
            }
            queue.put(mQMsg, pmo);
            LOGGER.debug((Object)("Message successfully written to " + queue.getName()));
        }
        catch (MQException | IOException ex) {
            throw new ConnectorException("queue not be written: " + this.qName, ex);
        }
    }

    public void putMessage(byte[] message, String name) {
        try {
            MQQueueManager qMgr = this.newMQQueueManager();
            int openOptions = 16;
            switch (this.qOption) {
                case SetMsgId: {
                    openOptions = 2064;
                    break;
                }
                case SetMsgIdAndUserId: {
                    openOptions = 1040;
                    break;
                }
            }
            MQQueue queue = qMgr.accessQueue(this.qName, openOptions);
            this.write(queue, name, message);
            queue.close();
        }
        catch (MQException ex) {
            throw new ConnectorException("can not write queue: " + this.qName, ex);
        }
    }

    private MQQueueManager newMQQueueManager() {
        if (null == cache.get(this.qManager)) {
            LOGGER.debug((Object)("Connecting MQQueueManager " + this.qManager));
            try {
                cache.put(this.qManager, new MQQueueManager(this.qManager, new Hashtable<String, Object>(this.mqEnv)));
            }
            catch (MQException e) {
                throw new ConnectorException("MQQueueManager not available: " + this.qManager, e);
            }
        }
        return cache.get(this.qManager);
    }

    public String getQName() {
        return this.qName;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String toString() {
        return "WebsphereMQ(qManager=" + this.qManager + ", qName=" + this.qName + ", hostname=" + this.hostname + ", port=" + this.port + ", channelname=" + this.channelname + ")";
    }

    public abstract String getId();

    public abstract String getType();

    public HashMap<String, Object> getMqEnv() {
        return this.mqEnv;
    }

    private static enum QueueOption {
        GenerateMsgId("GenerateMsgId"),
        SetMsgId("SetMsgId"),
        SetMsgIdAndUserId("SetMsgIdAndUserId");


        private QueueOption(String opt) {
        }
    }
}

