/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQRFH2;
import io.github.rockitconsulting.test.rockitizer.payload.model.MqPayload;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MQPayloadBuilder {
    public static final Logger LOGGER = Logger.getLogger((String)MQPayloadBuilder.class.getName());
    private static final Pattern CLEAN_INVALID_CHARS = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFF]+");

    public static MQMessage newMqMessageFromXMLString(byte[] message) throws IOException {
        MQMessage mQMsg = new MQMessage();
        String msg = CLEAN_INVALID_CHARS.matcher(new String(message)).replaceAll("");
        MqPayload p = MQPayloadBuilder.newMqPayloadFromXMLString(msg = msg.replace("\r", "").replace("\n", "").replaceAll(">\\s+<", "><"));
        if (p != null) {
            mQMsg.characterSet = p.getHeader().getCodedCharSetId();
            mQMsg.messageType = p.getHeader().getMsgType();
            mQMsg.correlationId = p.getHeader().getCorrelId().getBytes();
            mQMsg.expiry = p.getHeader().getExpiry();
            mQMsg.messageId = p.getHeader().getMsgId().getBytes();
            mQMsg.replyToQueueName = p.getHeader().getReplyToQ().trim();
            mQMsg.replyToQueueManagerName = p.getHeader().getReplyToQMgr().trim();
            if (p.getHeader().getRfh2Header() != null && !p.getHeader().getRfh2Header().isEmpty()) {
                MQRFH2 rfh2 = new MQRFH2();
                rfh2.setFolderStrings((String[])p.getHeader().getRfh2Header().stream().toArray(String[]::new));
                rfh2.write((DataOutput)mQMsg);
                mQMsg.format = "MQHRF2  ";
            } else {
                mQMsg.format = p.getHeader().getMsgFormat();
            }
        } else {
            mQMsg.format = "MQSTR";
            mQMsg.characterSet = 1208;
            mQMsg.messageType = 8;
            mQMsg.expiry = -1;
        }
        mQMsg.write(p != null ? p.getBody().getBytes() : msg.getBytes());
        return mQMsg;
    }

    public static MqPayload newMqPayloadFromXMLString(String msg) {
        MqPayload p = null;
        try {
            p = new MqPayload();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MqPayload.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader reader = new StringReader(msg);
            p = (MqPayload)unmarshaller.unmarshal((Reader)reader);
            if (p.getHeader().getRfh2Header() != null && !p.getHeader().getRfh2Header().isEmpty()) {
                p.getHeader().getRfh2Header().clear();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(msg)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression exprHeader = xPath.compile("/mqPayload/header/rfh2Headers/rfh2Header");
            NodeList nodesHeader = (NodeList)exprHeader.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodesHeader.getLength(); ++i) {
                p.getHeader().getRfh2Header().add(MQPayloadBuilder.innerXml(nodesHeader.item(i)));
            }
            XPathExpression exprBody = xPath.compile("/mqPayload/body");
            NodeList nodesBody = (NodeList)exprBody.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodesBody.getLength(); ++i) {
                p.setBody(MQPayloadBuilder.innerXml(nodesBody.item(i)));
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            p = null;
            LOGGER.warn((Object)("no mqPayload envelope found, continue processing legacy message " + e.getMessage()));
        }
        return p;
    }

    public static MqPayload newPayload(MQMessage msg) throws MQDataException, IOException {
        MqPayload mqPayload = new MqPayload();
        if (msg.format.contains("MQHRF2")) {
            msg.seek(0);
            MQRFH2 rfh2 = new MQRFH2((DataInput)msg);
            if (rfh2.getFolders().length > 0) {
                mqPayload.getHeader().setRfh2Header(Arrays.asList(rfh2.getFolderStrings()));
            }
        }
        mqPayload.getHeader().setCodedCharSetId(msg.characterSet);
        mqPayload.getHeader().setMsgType(msg.messageType);
        mqPayload.getHeader().setCorrelId(new String(msg.correlationId, StandardCharsets.UTF_8).trim());
        mqPayload.getHeader().setMsgFormat(msg.format.trim());
        mqPayload.getHeader().setMsgId(new String(msg.messageId, StandardCharsets.UTF_8).trim());
        mqPayload.getHeader().setReplyToQ(msg.replyToQueueName.trim());
        mqPayload.getHeader().setReplyToQMgr(msg.replyToQueueManagerName.trim());
        mqPayload.setBody(msg.readStringOfByteLength(msg.getDataLength()).replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").trim());
        return mqPayload;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toXmlString(MqPayload payload) {
        try (StringWriter writer = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MqPayload.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal((Object)payload, (Writer)writer);
            String replaceAll = StringEscapeUtils.unescapeXml((String)writer.toString().replace("&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;", ""));
            String string = CLEAN_INVALID_CHARS.matcher(replaceAll).replaceAll("");
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static String innerXml(Node node) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer lsSerializer = lsImpl.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("xml-declaration", false);
        NodeList childNodes = node.getChildNodes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            sb.append(lsSerializer.writeToString(childNodes.item(i)));
        }
        return sb.toString();
    }
}

