/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.rockit.common.blackboxtester.connector.WriteConnector;
import com.rockit.common.blackboxtester.exceptions.ConnectorException;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import com.rockit.common.blackboxtester.suite.configuration.PayloadReplacer;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.SCPConnectorCfg;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class SCPPutConnector
implements WriteConnector {
    private String id;
    private Session session;
    private ChannelSftp channel;
    private String destPath;
    private File contentFile;
    private String host;
    private String user;
    private String password;

    public SCPPutConnector(String id) {
        this.id = id;
        SCPConnectorCfg cfg = (SCPConnectorCfg)Configuration.configuration().getConnectorById(id);
        this.host = cfg.getHost();
        this.user = cfg.getUser();
        this.password = cfg.getPassword();
        this.destPath = cfg.getPath();
    }

    public void connect(String host, String user, String password) {
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        JSch jsch = new JSch();
        try {
            this.session = jsch.getSession(user, host, 22);
            this.session.setConfig(config);
            this.session.setPassword(password);
            this.session.connect();
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new ConnectorException("Can not establish connection to " + host, e);
        }
    }

    public boolean copy() {
        this.proceed();
        return true;
    }

    @Override
    public void proceed() {
        try {
            this.connect(this.host, this.user, this.password);
            String targetFilename = this.contentFile.getName();
            this.channel.cd(this.destPath);
            this.channel.put((InputStream)new FileInputStream(this.contentFile), targetFilename, 0);
            if (targetFilename.endsWith(".trans")) {
                String targetFilenameRenamed = targetFilename.replaceAll(".trans", ".csv");
                this.channel.rename(targetFilename, this.destPath + "/" + targetFilenameRenamed);
            }
        }
        catch (Exception e) {
            throw new ConnectorException("[Connector:" + this.getId() + "] \t Connector error: " + this.getType(), e);
        }
        finally {
            this.channel.exit();
            this.session.disconnect();
        }
    }

    @Override
    public String getType() {
        return Constants.Connectors.SCPPUT.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setRequest(File requestFile) {
        this.contentFile = PayloadReplacer.interpolate(requestFile, Configuration.configuration().getPayloadReplacements());
    }

    @Override
    public void setRequest(String request) {
        throw new ConnectorException("[Connector:" + this.getId() + "] \t Set method is not allowed");
    }
}

