/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.connector.impl.db;

import com.rockit.common.blackboxtester.exceptions.GenericException;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.DBDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.log4j.Logger;

public class DatabaseConnection {
    public static final Logger LOGGER = Logger.getLogger((String)DatabaseConnection.class.getName());
    protected String dbUrl;
    protected String dbUser;
    protected String dbPwd;
    protected Connection connection;

    public DatabaseConnection(String id) {
        DBConnectorCfg dbConCfg = (DBConnectorCfg)Configuration.configuration().getConnectorById(id);
        DBDataSource ds = Configuration.configuration().getDBDataSourceByConnector(dbConCfg);
        this.dbUrl = ds.getUrl();
        this.dbUser = ds.getUser();
        this.dbPwd = ds.getPassword();
    }

    protected void createDatabaseConnection() {
        try {
            Class.forName(this.dbUrl.contains("db2") ? "com.ibm.db2.jcc.DB2Driver" : "oracle.jdbc.driver.OracleDriver").newInstance();
            this.connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPwd);
        }
        catch (Exception e) {
            throw new GenericException("DB Connection object cannot be instantiated. \nurl:" + this.dbUrl + ", user:" + this.dbUser + ", password:" + this.dbPwd, e);
        }
    }
}

