/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.suite.configuration;

import com.google.common.collect.ImmutableList;
import com.rockit.common.blackboxtester.connector.Connector;
import com.rockit.common.blackboxtester.connector.impl.DBGetConnector;
import com.rockit.common.blackboxtester.connector.impl.DBPutConnector;
import com.rockit.common.blackboxtester.connector.impl.FileDelConnector;
import com.rockit.common.blackboxtester.connector.impl.FileGetConnector;
import com.rockit.common.blackboxtester.connector.impl.FilePutConnector;
import com.rockit.common.blackboxtester.connector.impl.HTTPConnector;
import com.rockit.common.blackboxtester.connector.impl.MQGetConnector;
import com.rockit.common.blackboxtester.connector.impl.MQPutConnector;
import com.rockit.common.blackboxtester.connector.impl.SCPPutConnector;
import com.rockit.common.blackboxtester.exceptions.GenericException;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class ConnectorFactory {
    public static final Logger LOGGER = Logger.getLogger((String)ConnectorFactory.class.getName());

    private ConnectorFactory() {
        throw new IllegalAccessError("ConnectorFactory class");
    }

    public static List<Connector> connectorByFolder(String name) {
        String type;
        if (name.indexOf(64) != -1) {
            throw new RuntimeException("@ are no longer supported since version 0.6. Please use the pattern {Connector}.{Variable}");
        }
        switch (type = ConfigUtils.connectorTypeFromConnectorId(name)) {
            case "MQPUT": {
                return ImmutableList.of((Object)new MQPutConnector(name));
            }
            case "MQGET": {
                return ImmutableList.of((Object)new MQGetConnector(name));
            }
            case "DBPUT": {
                return ImmutableList.of((Object)new DBPutConnector(name));
            }
            case "HTTP": {
                return ImmutableList.of((Object)new HTTPConnector(name));
            }
            case "DBGET": {
                return ImmutableList.of((Object)new DBGetConnector(name));
            }
            case "SCPPUT": {
                return ImmutableList.of((Object)new SCPPutConnector(name));
            }
            case "FILEGET": {
                return ImmutableList.of((Object)new FileGetConnector(name));
            }
            case "FILEPUT": {
                return ImmutableList.of((Object)new FilePutConnector(name));
            }
            case "FILEDEL": {
                return ImmutableList.of((Object)new FileDelConnector(name));
            }
        }
        LOGGER.error((Object)("No Connector found for [" + name + "]"));
        throw new GenericException("Unsuppored connector for [" + name + "]");
    }
}

