/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.suite.structures;

import com.rockit.common.blackboxtester.exceptions.GenericException;
import com.rockit.common.blackboxtester.suite.structures.ConnectorFolder;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import org.apache.log4j.Logger;

public class AbstractTestFolder {
    public static final Logger LOGGER = Logger.getLogger((String)ConnectorFolder.class.getName());
    private String inFolderName;
    private String outFolderName;
    private String testName;
    private String testStepName;
    private String connectorName;
    private String connectorType;

    protected AbstractTestFolder(String testName) {
        this.testName = testName;
        this.inFolderName = testName + "/";
        this.outFolderName = testName + "/" + "output" + "/";
    }

    protected AbstractTestFolder(String testName, String testStepName) {
        this.testName = testName;
        this.testStepName = testStepName;
        this.inFolderName = testName + "/" + testStepName + "/";
        this.outFolderName = testName + "/" + "output" + "/" + testStepName + "/";
    }

    protected AbstractTestFolder(String testName, String testStepName, String connectorName) {
        this.testName = testName;
        this.testStepName = testStepName;
        this.connectorName = connectorName;
        this.inFolderName = testName + "/" + testStepName + "/" + connectorName + "/";
        this.outFolderName = testName + "/" + "output" + "/" + testStepName + "/" + connectorName + "/";
        this.connectorType = ConfigUtils.connectorTypeFromConnectorId(connectorName) + ".";
    }

    public String getTestName() {
        return this.testName;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getOutFolderName() {
        return this.outFolderName;
    }

    public String getInFolderName() {
        return this.inFolderName;
    }

    public String getTestStepName() {
        return this.testStepName;
    }

    public File getInFolder() {
        File inFoler = new File(this.getBasePath() + this.inFolderName);
        if (!inFoler.exists()) {
            throw new GenericException("Folder " + inFoler + " doesn't exist!");
        }
        return new File(this.getBasePath() + this.inFolderName);
    }

    protected File getOutFolder() {
        return this.getOrCreateFolder(this.getBasePath() + File.separator + this.outFolderName);
    }

    protected String getBasePath() {
        return this.isReplayMode() ? this.getReplayRootPath() : this.getRecordRootPath();
    }

    public boolean isReplayMode() {
        return Configuration.configuration().getRunMode() == Configuration.RunModeTypes.REPLAY;
    }

    public boolean isAssertMode() {
        return Configuration.configuration().getRunMode() == Configuration.RunModeTypes.ASSERT;
    }

    public boolean isRecordMode() {
        return Configuration.configuration().getRunMode() == Configuration.RunModeTypes.RECORD;
    }

    public String getRecordRootPath() {
        return ConfigUtils.getAbsolutePathToRoot() + "/src/test/resources/";
    }

    public String getReplayRootPath() {
        return ConfigUtils.getAbsolutePathToRoot() + "/target/replay/";
    }

    private File getOrCreateFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            LOGGER.debug((Object)(" creating folder " + file));
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            LOGGER.error((Object)"Folders only allowed");
            throw new GenericException(new RuntimeException("File found, but folders only allowed:" + path));
        }
        return file;
    }

    public void setTestStepName(String testStepName) {
        this.testStepName = testStepName;
    }

    public String printDescription() {
        return this.getDescrptionText() != null ? "\n" + this.getLeftShiftLength() + "DESC: [" + this.getDescrptionText() + "]" : "";
    }

    private String getLeftShiftLength() {
        if (this.connectorName != null) {
            return "                ";
        }
        if (this.testStepName != null) {
            return "        ";
        }
        return "          ";
    }

    private String getDescrptionText() {
        return FileUtils.readFile(new File(this.getRecordRootPath() + "/" + this.inFolderName + "/" + "description.txt"));
    }
}

