/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.suite.structures;

import com.google.common.io.Files;
import com.rockit.common.blackboxtester.connector.Connector;
import com.rockit.common.blackboxtester.connector.ReadConnector;
import com.rockit.common.blackboxtester.connector.WriteConnector;
import com.rockit.common.blackboxtester.exceptions.GenericException;
import com.rockit.common.blackboxtester.suite.configuration.ConnectorFactory;
import com.rockit.common.blackboxtester.suite.configuration.Constants;
import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import com.rockit.common.blackboxtester.suite.structures.AbstractTestFolder;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ConnectorFolder
extends AbstractTestFolder {
    protected ConnectorFolder(String testName, String testStepName, String connectorName) {
        super(testName, testStepName, connectorName);
    }

    public void execute() {
        List<Connector> connectors = this.getConnectorByFolderName();
        if (connectors.isEmpty()) {
            throw new GenericException(" teststep cannot be empty " + this.getInFolder());
        }
        for (Connector connector : connectors) {
            this.execute(connector);
        }
    }

    private void execute(Connector connector) {
        if (Constants.Connectors.MQGET.toString().equalsIgnoreCase(connector.getType())) {
            this.handleMQGetConnector(connector);
            return;
        }
        if (FileUtils.listFiles(this.getInFolder(), true).iterator().hasNext()) {
            this.handlePayloads(connector);
        } else {
            this.handleReadConnector(connector);
        }
    }

    private void handleReadConnector(Connector connector) {
        TestProtocol.write("        [Connector:" + connector.getId() + "] " + this.printDescription() + " - Reading ...");
        connector.proceed();
        if (connector instanceof ReadConnector) {
            this.saveResponse(connector, "0.txt");
        }
    }

    private void handlePayloads(Connector connector) {
        for (File input : FileUtils.listFiles(this.getInFolder(), true)) {
            if (input.getName().equalsIgnoreCase("description.txt")) continue;
            ((WriteConnector)connector).setRequest(input);
            TestProtocol.write("        [Connector:" + connector.getId() + "] " + this.printDescription() + "- Writing ...");
            connector.proceed();
            if (!(connector instanceof ReadConnector)) continue;
            TestProtocol.write("        [Connector:" + connector.getId() + "] " + this.printDescription() + " - Reading ...");
            this.saveResponse(connector, input.getName());
        }
    }

    private void handleMQGetConnector(Connector connector) {
        int idx = 0;
        do {
            TestProtocol.write("        [Connector:" + connector.getId() + "] " + this.printDescription() + " - Reading ...");
            connector.proceed();
            String response = ((ReadConnector)connector).getResponse();
            if (null == response) continue;
            try {
                Files.write((byte[])response.getBytes("UTF-8"), (File)new File(this.getOutFolder() + "/" + idx + ".txt"));
            }
            catch (IOException e) {
                throw new GenericException("can not write output file " + idx, e);
            }
            ++idx;
        } while (null != ((ReadConnector)connector).getResponse() && Constants.Connectors.MQGET.toString().equalsIgnoreCase(connector.getType()));
    }

    private void saveResponse(Connector connector, String fileName) {
        String response = ((ReadConnector)connector).getResponse();
        if (null != response) {
            try {
                Files.write((byte[])response.getBytes("UTF-8"), (File)new File(this.getOutFolder() + "/" + fileName));
            }
            catch (IOException e) {
                throw new GenericException("can not write output file " + fileName, e);
            }
        }
    }

    private List<Connector> getConnectorByFolderName() {
        return ConnectorFactory.connectorByFolder(this.getInFolder().getName());
    }
}

