/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.suite.structures;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.rockit.common.blackboxtester.assertions.Assertions;
import com.rockit.common.blackboxtester.assertions.FileAssertion;
import com.rockit.common.blackboxtester.exceptions.GenericException;
import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import com.rockit.common.blackboxtester.suite.structures.AbstractTestFolder;
import com.rockit.common.blackboxtester.suite.structures.TestStepBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TestBuilder
extends AbstractTestFolder {
    private List<Assertions> assertions = Lists.newArrayList();

    public TestBuilder(Class<?> clazz) {
        super(clazz.getSimpleName());
    }

    public TestStepBuilder addStep(String stepName) {
        super.setTestStepName(stepName);
        if (this.isReplayMode()) {
            this.copyRecordToReplayTarget(stepName);
        }
        return new TestStepBuilder(this.getTestName(), stepName);
    }

    public TestBuilder addAssertion(Assertions assertion) {
        assertion.setRecordPath(this.getRecordOutputFolder());
        assertion.setReplayPath(this.getReplayOutputFolder());
        this.assertions.add(assertion);
        return this;
    }

    public void proceedAssertions() {
        this.assertions.add(new FileAssertion(this.getRecordOutputFolder(), this.getReplayOutputFolder()));
        this.assertions.add(new FileAssertion(this.getReplayOutputFolder(), this.getRecordOutputFolder()));
        for (Assertions assertion : this.assertions) {
            assertion.proceed();
        }
        TestProtocol.write(" Number of assertions processed successfully: " + this.assertions.size() + " [\n\t" + Joiner.on((String)",\n\t").join(this.assertions) + "\n      ]");
    }

    public void deleteOutputFolder() throws IOException {
        if (!this.isReplayMode()) {
            TestProtocol.write("        Deleting record output folder " + this.getRecordOutputFolder());
            FileUtils.deleteDirectory((File)new File(this.getRecordOutputFolder()));
        } else {
            TestProtocol.write("        Deleting replay  folder " + this.getReplayFolder());
            FileUtils.deleteDirectory((File)new File(this.getReplayFolder()));
        }
    }

    protected String getRecordOutputFolder() {
        return this.getRecordFolder() + "output";
    }

    protected String getReplayOutputFolder() {
        return this.getReplayFolder() + "output";
    }

    public String getRecordFolder() {
        return this.getRecordRootPath() + this.getInFolderName();
    }

    public String getReplayFolder() {
        return this.getReplayRootPath() + this.getInFolderName();
    }

    private void copyRecordToReplayTarget(String stepName) {
        if (!new File(this.getRecordFolder() + "/" + stepName).exists()) {
            new File(this.getRecordFolder() + "/" + stepName).mkdirs();
        }
        new File(this.getReplayFolder() + "/" + stepName).mkdirs();
        try {
            FileUtils.copyDirectory((File)new File(this.getRecordFolder() + "/" + stepName), (File)new File(this.getReplayFolder() + "//" + stepName));
        }
        catch (IOException e) {
            throw new GenericException("Can not make copy of " + this.getRecordFolder() + "/" + stepName + " to replay target " + this.getReplayFolder() + "/" + stepName, e);
        }
    }

    public boolean isRecordFolderExists() {
        return new File(this.getRecordFolder()).exists();
    }
}

