/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.suite.structures;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import com.rockit.common.blackboxtester.suite.structures.AbstractTestFolder;
import com.rockit.common.blackboxtester.suite.structures.ConnectorFolder;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;

public class TestStepBuilder
extends AbstractTestFolder {
    private Iterable<ConnectorFolder> connectorFolders;

    protected TestStepBuilder(String testName, String testStepName) {
        super(testName, testStepName);
        TestProtocol.writeStep(testStepName + this.printDescription());
    }

    public TestStepBuilder execute() {
        if (this.isAssertMode()) {
            return this;
        }
        try {
            for (ConnectorFolder connectorFolder : this.getConnectorFolders()) {
                connectorFolder.execute();
            }
        }
        catch (Exception ex) {
            TestProtocol.writeFatal(ex);
            throw ex;
        }
        return this;
    }

    protected Iterable<ConnectorFolder> getConnectorFolders() {
        if (null == this.connectorFolders) {
            this.connectorFolders = Iterables.transform(FileUtils.listFolders(this.getInFolder()), (Function)new Function<File, ConnectorFolder>(){

                public ConnectorFolder apply(File subfolder) {
                    return new ConnectorFolder(TestStepBuilder.this.getTestName(), TestStepBuilder.this.getTestStepName(), subfolder.getName());
                }
            });
        }
        return this.connectorFolders;
    }

    protected String relativize(String path) {
        return new File(this.getBasePath()).toURI().relativize(new File(path).toURI()).getPath();
    }

    public TestStepBuilder sleep(int ms) {
        if (this.isAssertMode()) {
            return this;
        }
        TestProtocol.write("        Waiting " + ms + "ms for results...");
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            TestProtocol.writeError("thread is interrupted " + Thread.currentThread().getName(), e);
            Thread.currentThread().interrupt();
        }
        return this;
    }
}

