/*
 * Decompiled with CFR 0.152.
 */
package com.rockit.common.blackboxtester.wrapper;

import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import com.rockit.common.blackboxtester.suite.structures.TestBuilder;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractTestWrapper {
    private TestBuilder testBuilder;
    public static final Logger LOGGER = Logger.getLogger((String)AbstractTestWrapper.class.getName());

    @Before
    public void preProcess() throws IOException {
        TestProtocol.writeHeading(this.testBuilder.getTestName(), "Configuration");
        TestProtocol.write(this.testBuilder);
        TestProtocol.writeHeading(this.testBuilder.getTestName(), "Executing  [" + (Object)((Object)Configuration.configuration().getRunMode()) + " for Env: " + (Configuration.configuration().getEnvironment() != null ? Configuration.configuration().getEnvironment() : "default") + "]" + this.testBuilder.printDescription());
        if (!this.testBuilder.isRecordFolderExists()) {
            TestProtocol.writeError("Record folder doesn't exist: " + this.testBuilder.getRecordFolder());
            System.exit(1);
        }
        if (!this.testBuilder.isAssertMode()) {
            this.testBuilder.addStep("000BEFORE").execute();
            this.testBuilder.deleteOutputFolder();
        }
    }

    @After
    public void postProcess() {
        if (!this.testBuilder.isAssertMode()) {
            this.testBuilder.addStep("999AFTER").execute();
        }
        if (this.testBuilder.isRecordMode()) {
            TestProtocol.write("You are running in 'record' mode. Assertions are only possible in 'replay' or 'assert' modes. Kindly use cli run or set the 'mode' parameter for JUnit directly.");
            return;
        }
        TestProtocol.writeHeading(this.testBuilder.getTestName(), "Assertion");
        this.testBuilder.proceedAssertions();
    }

    public TestBuilder newTestBuilderFor(Class<? extends AbstractTestWrapper> clazz) {
        Configuration.configuration();
        this.testBuilder = new TestBuilder(clazz);
        return this.testBuilder;
    }
}

