/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.cli;

import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.validation.ValidationUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="create-test", sortOptions=false, headerHeading="@|bold,underline Usage:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"cli create-test <testcase> [<teststep>] [<connector>]"}, description={" Creates the test objects in the file system. E.g.:%n%n FILEinFILEOutTest%n       \\_0BEFORE%n              \\__FILEDEL.IN.FILE2FILE%n              \\__FILEDEL.OUT.FILE2FILE%n       \\_a001FILEPutMessage%n              \\__FILEPUT.IN.FILE2FILE%n                      \\__testinput.xml%n       \\_a002FILEGetMessage%n              \\__FILEGET.OUT.FILE2FILE%n"}, footer={"%nNotice: You are free to use any file manager to create testcases."})
public class RockitizerCreateTest
implements Runnable {
    @CommandLine.Parameters(index="0", arity="1", description={"TestCase name (For Maven compatibility, best practice is to use \"Test\" in testcase names. E.g. \"MyFirstTest\")"})
    String testcase;
    @CommandLine.Parameters(index="1", arity="0..1", description={"TestStep name (For name-based sorting, best practice is to use indexing in teststep names. E.g. \"0InitialStep\", \"1NextStep\" etc.)"})
    String teststep;
    @CommandLine.Parameters(index="2", arity="0..1", description={"Connector: HTTP.<ID>, SCPPUT.<ID>, MQGET.<ID>, MQPUT.<ID>, FILEPUT.<ID>, FILEDEL.<ID>, FILEGET.<ID>, DBGET.<ID>, DBPUT.<ID>"})
    String connector;

    @Override
    public void run() {
        File fPath = new File(ConfigUtils.getAbsolutePathToJava() + this.testcase + ".java");
        try {
            if (this.teststep != null && this.connector != null) {
                ValidationUtils.validateConnector(this.connector);
                this.createConnector();
            } else if (this.teststep != null) {
                this.createTesStep();
            } else {
                this.createTestCase();
            }
            if (!fPath.exists()) {
                this.createJunitClass(fPath);
            }
        }
        catch (Exception e) {
            System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Error occured: |@" + e));
        }
    }

    void createTestCase() throws IOException {
        String path = Configuration.configuration().getFullPath() + this.testcase;
        new File(path).mkdirs();
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully created: |@" + path));
    }

    void createTesStep() throws IOException {
        String path = Configuration.configuration().getFullPath() + this.testcase + File.separator + this.teststep;
        new File(path).mkdirs();
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully created: |@" + path));
    }

    void createConnector() throws IOException {
        String path = Configuration.configuration().getFullPath() + this.testcase + File.separator + this.teststep + File.separator + this.connector;
        new File(path).mkdirs();
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully created: |@" + path));
    }

    void createJunitClass(File fPath) {
        String sPath = fPath.toString();
        try (FileWriter myWriter = new FileWriter(sPath);){
            myWriter.write("import org.apache.log4j.Logger;" + System.lineSeparator());
            myWriter.write("import org.junit.Test;" + System.lineSeparator());
            myWriter.write("import org.xmlunit.diff.ElementSelectors;" + System.lineSeparator());
            myWriter.write(" " + System.lineSeparator());
            myWriter.write("import com.google.common.collect.ImmutableList;" + System.lineSeparator());
            myWriter.write("import com.rockit.common.blackboxtester.assertions.XMLFileAssertion;" + System.lineSeparator());
            myWriter.write("import com.rockit.common.blackboxtester.suite.structures.TestBuilder;" + System.lineSeparator());
            myWriter.write("import com.rockit.common.blackboxtester.wrapper.AbstractTestWrapper;" + System.lineSeparator());
            myWriter.write(" " + System.lineSeparator());
            myWriter.write("public class " + this.testcase + " extends AbstractTestWrapper {" + System.lineSeparator());
            myWriter.write("\tpublic static Logger logger = Logger.getLogger(" + this.testcase + ".class.getName());" + System.lineSeparator());
            myWriter.write("\tpublic TestBuilder testBuilder = newTestBuilderFor(" + this.testcase + ".class);" + System.lineSeparator());
            myWriter.write(" " + System.lineSeparator());
            myWriter.write("\t@Test" + System.lineSeparator());
            myWriter.write("\tpublic void test" + this.testcase.replaceFirst("Test", "") + "() throws Exception {" + System.lineSeparator());
            myWriter.write(" " + System.lineSeparator());
            myWriter.write(" " + System.lineSeparator());
            myWriter.write("\t}" + System.lineSeparator());
            myWriter.write("}" + System.lineSeparator());
            myWriter.close();
        }
        catch (IOException e) {
            System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Failed by generation: |@" + e));
        }
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully JUnit template created: |@" + sPath));
    }
}

