/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.cli;

import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="delete-test", sortOptions=false, headerHeading="@|bold,underline Usage:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"cli delete-test <testcase> [<teststep>] [<connector>]"}, description={"Deletes test objects in file system and generates a log message for the user, describing the changes."})
public class RockitizerDeleteTest
implements Runnable {
    @CommandLine.Parameters(index="0", arity="1", description={"TestCase name "})
    String testcase;
    @CommandLine.Parameters(index="1", arity="0..1", description={"TestStep name "})
    String teststep;
    @CommandLine.Parameters(index="2", arity="0..1", description={"Connector : HTTP.<ID>, SCPPUT.<ID>, MQGET.<ID>, MQPUT.<ID>, FILEPUT.<ID>, FILEDEL.<ID>, FILEGET.<ID>, DBGET.<ID>, DBPUT.<ID>"})
    String connector;

    @Override
    public void run() {
        String path;
        if (this.teststep != null && this.connector != null) {
            path = Configuration.configuration().getFullPath() + this.testcase + File.separator + this.teststep + File.separator + this.connector;
            FileUtils.deleteDirectory(new File(path));
        } else if (this.teststep != null) {
            path = Configuration.configuration().getFullPath() + this.testcase + File.separator + this.teststep;
            FileUtils.deleteDirectory(new File(path));
        } else {
            path = Configuration.configuration().getFullPath() + this.testcase;
            FileUtils.deleteDirectory(new File(path));
            new File(ConfigUtils.getAbsolutePathToJava() + this.testcase + ".java").delete();
            System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully Deleted: |@" + ConfigUtils.getAbsolutePathToJava() + this.testcase + ".java"));
        }
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully Deleted: |@" + path));
    }
}

