/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.cli;

import com.google.common.base.Strings;
import io.github.rockitconsulting.test.rockitizer.cli.CommonCLI;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.ResourcesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import io.github.rockitconsulting.test.rockitizer.validation.Validatable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="list-resources", sortOptions=false, headerHeading="@|bold,underline Benutzung:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"cli list-resources [-v[=<yaml|tree>]] [<env>]"}, description={"Generates listing of resources-<env>.yaml View type by default: tree.%n%n        E.g. tree view:                           E.g. yaml view:%nmqConnectors                                     mqConnectors:%n             @|bold,yellow \\_|@id:MQGET.ERROR                    - id: MQGET.ERROR%n               type:MQGET                          type: MQGET%n               queue:MQ.ERROR                      queue: MQ.ERROR%n               dsRefId:defaultMQ                   dsRefId: defaultMQ%n"})
public class RockitizerListResources
extends CommonCLI
implements Runnable {
    @CommandLine.Parameters(index="0", arity="0..1", description={" current env, e.g. devp "})
    String env;
    @CommandLine.Option(defaultValue="tree", names={"-v", "--view"}, arity="0..1", description={"type of view: ${COMPLETION-CANDIDATES}"})
    ViewType view = ViewType.tree;

    @Override
    public void run() {
        if (this.env != null) {
            System.setProperty("env", this.env);
        }
        try {
            if (this.view == ViewType.tree) {
                this.treeRC();
            } else {
                System.out.println(FileUtils.readFile(Configuration.configuration().getFullPath() + Configuration.configuration().getRhApi().getResourcesFileName()));
            }
        }
        catch (IOException e) {
            System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Error: |@" + e));
        }
    }

    private void treeRC() throws IOException {
        ResourcesHolder rhyaml = Configuration.configuration().getRhApi().resourcesHolderFromYaml();
        this.printPrintableResource(rhyaml.getMqConnectors(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow mqConnectors |@"));
        this.printPrintableResource(rhyaml.getFileConnectors(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow fileConnectors |@"));
        this.printPrintableResource(rhyaml.getHttpConnectors(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow httpConnectors |@"));
        this.printPrintableResource(rhyaml.getDbConnectors(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow dbConnectors |@"));
        this.printPrintableResource(rhyaml.getScpConnectors(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow scpConnectors |@"));
        this.printPrintableResource(rhyaml.getMqDataSources(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow mqDataSourcres |@"));
        this.printPrintableResource(rhyaml.getDbDataSources(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow dbDataSourcres |@"));
        this.printPrintableResource(rhyaml.getKeyStores(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow KeyStores |@"));
        this.printPrintableResource(rhyaml.getPayloadReplacer(), CommandLine.Help.Ansi.AUTO.string("@|bold,yellow payloadReplacer |@"));
    }

    private void printPrintableResource(List<? extends Validatable> resources, String root) {
        String rootPx = CommandLine.Help.Ansi.AUTO.string("@|bold,yellow \\_|@");
        String rootPrefix = "             " + rootPx;
        String linePrefix = Strings.padStart((String)"", (int)15, (char)' ');
        if (resources.size() > 0) {
            System.out.println(root);
        }
        resources.forEach(r -> r.getFieldsAsOrderedMap().forEach((k, v) -> {
            if (k.equals("id")) {
                System.out.println(rootPrefix + k + ":" + v);
            } else {
                System.out.println(linePrefix + k + ":" + v);
            }
        }));
    }

    private void printPrintableResource(Map<String, String> payloadReplacerMap, String root) {
        String rootPx = CommandLine.Help.Ansi.AUTO.string("@|bold,yellow \\_|@");
        String rootPrefix = "             " + rootPx;
        String linePrefix = Strings.padStart((String)"", (int)15, (char)' ');
        if (payloadReplacerMap.size() > 0) {
            System.out.println(root);
        }
        payloadReplacerMap.forEach((k, v) -> {
            if (k.equals(payloadReplacerMap.keySet().iterator().next())) {
                System.out.println(rootPrefix + k + ":" + v);
            } else {
                System.out.println(linePrefix + k + ":" + v);
            }
        });
    }

    static enum ViewType {
        yaml,
        tree;

    }
}

