/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.cli;

import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import picocli.CommandLine;

@CommandLine.Command(name="run", sortOptions=false, headerHeading="@|bold,underline Usage:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"cli run <testName | all> [<record | replay>] [<env>] [--skipTests[=<testname>]]"}, description={"Runs JUnit test or complete test suite in console, optionally requiring mode and environment.%nSupported modes are:%n  - RECORD (executing of master test/suite under src/test/resources/, keeping results under src/test/resources/<testcase>/output);%n  - REPLAY (copying master test to target, executing it and performing assertions);%n  - ASSERT (comparing the RECORD and REPLAY outputs). Best practice to use for tuning the assertions in order to get the best coverage.%n"}, footer={"%n%nNotice: For run, you can use following options: %n  - CLI;%n  - IDE/Standalone Maven Starter;%n  - IDE JUnit Starter.%n"})
public class RockitizerRunTest
extends JUnitCore
implements Runnable {
    @CommandLine.Parameters(index="0", arity="1", description={": MyJUnitTest or all "})
    String testname;
    @CommandLine.Parameters(index="1", arity="0..1", description={": ${COMPLETION-CANDIDATES}"})
    Configuration.RunModeTypes mode;
    @CommandLine.Parameters(index="2", arity="0..1", description={": e.g. env = dev"})
    String env;
    @CommandLine.Option(names={"-s", "--skipTests"}, arity="0..*", description={": e.g. --skipTests MyJUnitTest1 MyJUnitTest2"}, interactive=false)
    List<String> skipTests = new ArrayList<String>();

    @Override
    public void run() {
        ArrayList<Result> results = new ArrayList<Result>();
        ArrayList skippedTests = new ArrayList();
        try {
            if (this.mode != null) {
                System.setProperty("mode", this.mode.name());
            }
            if (this.env != null) {
                System.setProperty("env", this.env);
            }
            if (this.testname != null) {
                this.addListener((RunListener)new MyTextListener(System.out));
                if (this.testname.equalsIgnoreCase("all")) {
                    FileUtils.listFiles(new File(ConfigUtils.getAbsolutePathToJava())).forEach(test -> {
                        try {
                            if (!this.skipTests.stream().anyMatch(test.getName().replace(".java", "")::equals)) {
                                results.add(this.run(new Class[]{Class.forName(test.getName().replace(".java", ""))}));
                            } else {
                                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold Skipping Test |@" + test.getName().replace(".java", "")));
                                skippedTests.add(test.getName().replace(".java", ""));
                            }
                            System.out.println();
                        }
                        catch (Exception e) {
                            this.registerJunitError(results, e);
                        }
                    });
                } else {
                    results.add(this.run(new Class[]{Class.forName(this.testname)}));
                }
            }
        }
        catch (Throwable thr) {
            this.registerJunitError(results, thr);
        }
        int sumErrors = results.stream().mapToInt(Result::getFailureCount).sum();
        int sumRuns = results.stream().mapToInt(Result::getRunCount).sum();
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold Result: |@") + (sumErrors > 0 ? CommandLine.Help.Ansi.AUTO.string("@|bold,red NOK|@") : CommandLine.Help.Ansi.AUTO.string("@|bold,green OK|@")));
        System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold Total runs |@" + sumRuns));
        if (sumErrors > 0) {
            System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Total errors |@" + sumErrors));
        }
        if (!skippedTests.isEmpty()) {
            System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold, Total Tests skipped |@" + skippedTests.size() + " " + ((Object)skippedTests).toString()));
        }
    }

    private void registerJunitError(List<Result> results, Throwable thr) {
        System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Error: |@" + thr.getClass().getSimpleName() + " " + thr.getMessage()));
        Result result = new Result();
        result.getFailures().add(new Failure(null, thr));
        results.add(result);
    }

    private class MyTextListener
    extends TextListener {
        public MyTextListener(PrintStream writer) {
            super(writer);
        }

        public void testStarted(Description description) {
        }
    }
}

