/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.cli;

import com.google.common.base.Joiner;
import io.github.rockitconsulting.test.rockitizer.validation.ValidationHolder;
import io.github.rockitconsulting.test.rockitizer.validation.ValidationUtils;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="validate", sortOptions=false, headerHeading="@|bold,underline Usage:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"cli validate [-gitfix[=<true|false>]] [<env>]"}, description={" The following will be checked:%n     - referenced connectors must be present both in testcases.yaml and resources.yaml;%n     - connector type must be one of the following: MQPUT, MQGET, DBPUT, DBGET, HTTP, FILEDEL, FILEPUT, FILEGET, SCPPUT, SCPGET;%n     - referenced data sources must be available;%n     - not allowed empty folders must not be present or their presence must be ignored;%n     - test file structure must meet the testcases.yaml configuration;%n     - connector folders that require payloads must contain payloads;%n     - test .java file must be present for each test case;%n     - test case must be present for each test .java file;%n     - mandatory parameters must not be null or placeholders."})
public class RockitizerValidate
implements Runnable {
    @CommandLine.Option(defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, names={"-gitfix", "--addgitignore"}, arity="0..1", description={"add .gitignore to all GET connector folders to enforce git commit with empty folders."})
    boolean gitfix = false;
    @CommandLine.Parameters(index="0", arity="0..1", description={": env = dev => validation with environment-dependent resources-dev.yaml"})
    String env;

    @Override
    public void run() {
        if (this.env != null) {
            System.setProperty("env", this.env);
        }
        if (this.gitfix) {
            System.out.println("adding .gitignore to enforce git commit with empty folders");
            ValidationUtils.fixGitEmptyFoldersProblem();
            System.out.println("added .gitignore. Please re-run validation and commit if valid");
        }
        ValidationUtils.validateConnectorRefExists();
        ValidationUtils.validateResources();
        try {
            ValidationUtils.validateTestCasesAndFileSystemInSync();
            ValidationUtils.validateNotAllowedEmptyStructures();
            ValidationUtils.validateSyncJavaAndTestCases();
            if (ValidationHolder.validationHolder().size() > 0) {
                System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold Result: |@") + CommandLine.Help.Ansi.AUTO.string("@|bold,red NOK |@") + "Not valid with validation messages:");
                ValidationHolder.validationHolder().forEach((k, v) -> System.err.println(k + " - " + Joiner.on((String)";").join((Iterable)v)));
            } else {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,green Successfully: |@ Validation successfull. Please commit the changes if necessary."));
            }
        }
        catch (IOException e) {
            System.err.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Validation error: |@" + e));
        }
    }
}

