/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration;

import com.rockit.common.blackboxtester.exceptions.FatalConfigurationException;
import com.rockit.common.blackboxtester.suite.configuration.PayloadReplacer;
import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import io.github.rockitconsulting.test.rockitizer.configuration.EnvironmentsHolderAccessor;
import io.github.rockitconsulting.test.rockitizer.configuration.ResourcesHolderAccessor;
import io.github.rockitconsulting.test.rockitizer.configuration.TestCasesHolderAccessor;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.HTTPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.MQConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.DBDataSource;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.KeyStore;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.MQDataSource;
import io.github.rockitconsulting.test.rockitizer.validation.Validatable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class Configuration {
    private static ResourcesHolderAccessor rhApi;
    private static TestCasesHolderAccessor tchApi;
    private static Configuration INSTANCE;
    private RunModeTypes runMode = RunModeTypes.REPLAY;
    private String environment;
    private boolean initFromYaml = true;

    private Configuration() {
        this(new ResourcesHolderAccessor(), new TestCasesHolderAccessor());
    }

    private Configuration(ResourcesHolderAccessor rhcli, TestCasesHolderAccessor tchcli) {
        rhApi = rhcli;
        tchApi = tchcli;
        try {
            this.handleInitialization();
        }
        catch (Throwable thr) {
            TestProtocol.writeError("configuration initialization exception", thr);
            throw new FatalConfigurationException("configuration initialization exception", thr);
        }
    }

    private void handleInitialization() throws IOException {
        this.initEnvironmentFromSystemProperty();
        if (this.initFromYaml) {
            this.initAndLogRunModeFromSystemProperty();
            rhApi.initFromYaml();
            tchApi.initFromYaml();
        } else {
            rhApi.initFromFileSystem();
            tchApi.initFromFileSystem();
        }
    }

    private void initAndLogRunModeFromSystemProperty() {
        if (System.getProperty("mode") != null) {
            if (System.getProperty("mode").equalsIgnoreCase("replay")) {
                this.setRunMode(RunModeTypes.REPLAY);
            } else if (System.getProperty("mode").equalsIgnoreCase("assert")) {
                this.setRunMode(RunModeTypes.ASSERT);
            } else {
                this.setRunMode(RunModeTypes.RECORD);
            }
        }
    }

    private void initEnvironmentFromSystemProperty() {
        if (System.getProperty("initMode") != null) {
            this.initFromYaml = false;
        }
        if (System.getProperty("env") != null) {
            this.setEnvironment(System.getProperty("env"));
        } else {
            this.setEnvironment(null);
        }
    }

    public static synchronized Configuration configuration() {
        if (INSTANCE == null) {
            INSTANCE = new Configuration();
        }
        return INSTANCE;
    }

    public static synchronized void reset(ResourcesHolderAccessor rhcli, TestCasesHolderAccessor tchcli) {
        INSTANCE = new Configuration(rhcli, tchcli);
    }

    public void reinit() {
        try {
            this.handleInitialization();
        }
        catch (Throwable thr) {
            TestProtocol.writeError("configuration initialization exception", thr);
            throw new FatalConfigurationException("configuration initialization exception", thr);
        }
    }

    public RunModeTypes getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunModeTypes runMode) {
        this.runMode = runMode;
    }

    public ResourcesHolderAccessor getRhApi() {
        return rhApi;
    }

    public TestCasesHolderAccessor getTchApi() {
        return tchApi;
    }

    public String getFullPath() {
        return this.getTchApi().getFullPath();
    }

    public String getEnvironment() {
        return this.environment;
    }

    private void setEnvironment(String environment) {
        this.environment = environment;
        this.handleEnvironmentVariables(environment);
    }

    void handleEnvironmentVariables(String environment) {
        EnvironmentsHolderAccessor ehaApi = new EnvironmentsHolderAccessor();
        if (ehaApi.getEnvsHolder() != null) {
            Map<String, String> props = ehaApi.getEnvsHolder().getProps(environment);
            if (props != null) {
                this.interpolate(props);
            }
        } else {
            TestProtocol.writeWarn("env.yaml for environment variables not found. Fallback to using of default resources.yaml");
        }
    }

    private void interpolate(Map<String, String> props) {
        File resultResourcesEnv = PayloadReplacer.interpolate(new File(rhApi.getFullPath() + rhApi.getResourcesFileName()), props);
        rhApi.setEnvResourcesFile(resultResourcesEnv);
    }

    public Validatable getConnectorById(String id) {
        return this.getRhApi().getConnectorById(id);
    }

    public DBDataSource getDBDataSourceByConnector(DBConnectorCfg cfg) {
        return this.getRhApi().getDBDataSourceByConnector(cfg);
    }

    public MQDataSource getMQDataSourceByConnector(MQConnectorCfg cfg) {
        return this.getRhApi().getMQDataSourceByConnector(cfg);
    }

    public KeyStore getKeyStoreByConnector(HTTPConnectorCfg cfg) {
        return this.getRhApi().getKeyStoreByConnector(cfg);
    }

    public Map<String, String> getPayloadReplacements() {
        return this.getRhApi().getResourcesHolder().getPayloadReplacer();
    }

    static {
        INSTANCE = null;
    }

    public static enum RunModeTypes {
        REPLAY,
        RECORD,
        ASSERT;

    }
}

