/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration;

import io.github.rockitconsulting.test.rockitizer.configuration.RuntimeContext;
import io.github.rockitconsulting.test.rockitizer.configuration.model.ResourcesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.HTTPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.MQConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.SCPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.DBDataSource;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.KeyStore;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.MQDataSource;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.ConnectorRef;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import io.github.rockitconsulting.test.rockitizer.exceptions.InvalidConnectorFormatException;
import io.github.rockitconsulting.test.rockitizer.exceptions.ResourceNotFoundException;
import io.github.rockitconsulting.test.rockitizer.exceptions.ValidationException;
import io.github.rockitconsulting.test.rockitizer.validation.Validatable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourcesHolderAccessor
extends RuntimeContext {
    public static final Logger log = Logger.getLogger((String)ResourcesHolderAccessor.class.getName());
    private ResourcesHolder resourcesHolder;
    private File envResourcesFile;
    private String resourcesFileName = "resources.yaml";

    void initFromYaml() throws IOException {
        this.resourcesHolder = this.resourcesHolderFromYaml();
    }

    void initFromFileSystem() throws IOException {
        this.resourcesHolder = this.resourcesHolderFromFileSystemToYaml(null);
    }

    public ResourcesHolder resourcesHolderFromYaml(boolean forceOriginal) throws IOException {
        if (forceOriginal || !this.isEnvEnabled()) {
            return ConfigUtils.resourcesHolderFromYaml(this.getFullPath() + this.getResourcesFileName());
        }
        return ConfigUtils.resourcesHolderFromYaml(this.envResourcesFile.getAbsolutePath());
    }

    private boolean isEnvEnabled() {
        return this.envResourcesFile != null;
    }

    public ResourcesHolder resourcesHolderFromYaml() throws IOException {
        return this.resourcesHolderFromYaml(false);
    }

    public ResourcesHolder resourcesHolderFromFileSystem() {
        return this.resourcesHolderFromFileSystem(null);
    }

    ResourcesHolder resourcesHolderFromFileSystem(Map<String, String> payloadReplacer) {
        ResourcesHolder resources = new ResourcesHolder();
        if (payloadReplacer != null) {
            resources.setPayloadReplacer(payloadReplacer);
        }
        resources.getDbDataSources().add(new DBDataSource());
        resources.getMqDataSources().add(new MQDataSource());
        resources.getKeyStores().add(new KeyStore());
        FileUtils.listFolders(new File(this.getFullPath())).forEach(tcFolder -> FileUtils.listFolders(tcFolder).forEach(tsFolder -> {
            if (tsFolder.getName().equalsIgnoreCase("output")) {
                return;
            }
            FileUtils.listFolders(tsFolder).forEach(connFolder -> ConnectorFactory.processAddConnector(resources, connFolder));
        }));
        return resources;
    }

    public String getResourcesFileName() {
        return this.resourcesFileName;
    }

    public void setResourcesFileName(String resourcesFileName) {
        this.resourcesFileName = resourcesFileName;
    }

    public void resourcesHolderToYaml(ResourcesHolder resources) throws IOException {
        ConfigUtils.writeModelObjToYaml(resources, this.getFullPath() + this.getResourcesFileName());
    }

    public ResourcesHolder resourcesHolderFromFileSystemToYaml(Map<String, String> payloadReplacer) throws IOException {
        ResourcesHolder resources = this.resourcesHolderFromFileSystem(payloadReplacer);
        this.resourcesHolderToYaml(resources);
        return resources;
    }

    public Validatable getConnectorById(String id) {
        Validatable c = (Validatable)this.resourcesHolder.findResourceByRef(new ConnectorRef(id));
        if (c == null) {
            throw new ResourceNotFoundException(id);
        }
        if (!c.isValid()) {
            throw new ValidationException(c.validate());
        }
        return c;
    }

    public DBDataSource getDBDataSourceByConnector(DBConnectorCfg connector) {
        DBDataSource ds = this.resourcesHolder.findDBDataSourceById(connector.getDsRefId());
        if (ds == null) {
            throw new ResourceNotFoundException(connector.getDsRefId());
        }
        if (!ds.isValid()) {
            throw new ValidationException(ds.validate());
        }
        return ds;
    }

    public MQDataSource getMQDataSourceByConnector(MQConnectorCfg connector) {
        MQDataSource ds = this.resourcesHolder.findMQDataSourceById(connector.getDsRefId());
        if (ds == null) {
            throw new ResourceNotFoundException(connector.getDsRefId());
        }
        if (!ds.isValid()) {
            throw new ValidationException(ds.validate());
        }
        return ds;
    }

    public KeyStore getKeyStoreByConnector(HTTPConnectorCfg connector) {
        if (connector.getDsRefId() == null) {
            return null;
        }
        KeyStore ds = this.resourcesHolder.findKeyStoreById(connector.getDsRefId());
        if (ds == null) {
            throw new ResourceNotFoundException(connector.getDsRefId());
        }
        if (!ds.isValid()) {
            throw new ValidationException(ds.validate());
        }
        return ds;
    }

    public String contextAsString() {
        return "[ filename: " + this.getResourcesFileName() + ", absPath: " + this.getAbsolutePath() + ", relPath: " + this.getRelativePath() + "]";
    }

    public ResourcesHolder getResourcesHolder() {
        return this.resourcesHolder;
    }

    public void setResourcesHolder(ResourcesHolder resourcesHolder) {
        this.resourcesHolder = resourcesHolder;
    }

    File getEnvResourcesFile() {
        return this.envResourcesFile;
    }

    public void setEnvResourcesFile(File envResourcesFile) {
        this.envResourcesFile = envResourcesFile;
    }

    private static class ConnectorFactory {
        private ConnectorFactory() {
        }

        public static void processAddConnector(ResourcesHolder resources, File connFolder) {
            String cType;
            switch (cType = ConfigUtils.connectorTypeFromFolder(connFolder)) {
                case "HTTP": {
                    HTTPConnectorCfg httpConnector = new HTTPConnectorCfg(connFolder);
                    resources.addHttpConnector(httpConnector);
                    break;
                }
                case "FILEDEL": {
                    FileConnectorCfg fileDelConnector = new FileConnectorCfg(connFolder);
                    fileDelConnector.setType(FileConnectorCfg.Types.FILEDEL);
                    resources.addFileConnector(fileDelConnector);
                    break;
                }
                case "FILEPUT": {
                    FileConnectorCfg filePutConnector = new FileConnectorCfg(connFolder);
                    filePutConnector.setType(FileConnectorCfg.Types.FILEPUT);
                    resources.addFileConnector(filePutConnector);
                    break;
                }
                case "FILEGET": {
                    FileConnectorCfg fileGetConnector = new FileConnectorCfg(connFolder);
                    fileGetConnector.setType(FileConnectorCfg.Types.FILEGET);
                    resources.addFileConnector(fileGetConnector);
                    break;
                }
                case "MQGET": {
                    MQConnectorCfg mqGetConnector = new MQConnectorCfg(connFolder);
                    mqGetConnector.setType(MQConnectorCfg.Types.MQGET);
                    resources.addMqConnector(mqGetConnector);
                    break;
                }
                case "MQPUT": {
                    MQConnectorCfg mqPutConnector = new MQConnectorCfg(connFolder);
                    mqPutConnector.setType(MQConnectorCfg.Types.MQPUT);
                    resources.addMqConnector(mqPutConnector);
                    break;
                }
                case "DBPUT": {
                    DBConnectorCfg dbPutConnector = new DBConnectorCfg(connFolder);
                    dbPutConnector.setType(DBConnectorCfg.Types.DBPUT);
                    resources.addDbConnector(dbPutConnector);
                    break;
                }
                case "DBGET": {
                    DBConnectorCfg dbGetConnector = new DBConnectorCfg(connFolder);
                    dbGetConnector.setType(DBConnectorCfg.Types.DBGET);
                    resources.addDbConnector(dbGetConnector);
                    break;
                }
                case "SCPPUT": {
                    SCPConnectorCfg scpConnector = new SCPConnectorCfg(connFolder);
                    scpConnector.setType(SCPConnectorCfg.Types.SCPPUT);
                    resources.addScpConnector(scpConnector);
                    break;
                }
                default: {
                    throw new InvalidConnectorFormatException("Invalid connector : " + cType + " under " + connFolder.getAbsolutePath());
                }
            }
        }
    }
}

