/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration;

import io.github.rockitconsulting.test.rockitizer.configuration.RuntimeContext;
import io.github.rockitconsulting.test.rockitizer.configuration.model.TestCasesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.ConnectorRef;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.Payload;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.TestCase;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.TestStep;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TestCasesHolderAccessor
extends RuntimeContext {
    public static final Logger log = Logger.getLogger((String)TestCasesHolderAccessor.class.getName());
    private String testcasesFileName = "testcases.yaml";
    private TestCasesHolder testCasesHolder;

    void initFromYaml() throws IOException {
        this.testCasesHolder = this.testCasesHolderFromYaml();
    }

    void initFromFileSystem() throws IOException {
        this.testCasesHolder = this.testCasesHolderFromFileSystemToYaml();
    }

    public TestCasesHolder testCasesHolderFromYaml() throws IOException {
        return ConfigUtils.testCasesHolderFromYaml(this.getFullPath() + this.getTestcasesFileName());
    }

    public TestCasesHolder testCasesHolderFromFileSystem() {
        TestCasesHolder holder = new TestCasesHolder();
        FileUtils.listFolders(new File(this.getFullPath())).forEach(tcFolder -> {
            TestCase testCase = new TestCase((File)tcFolder);
            holder.getTestCases().add(testCase);
            FileUtils.listFolders(tcFolder).forEach(tsFolder -> {
                TestStep testStep = new TestStep((File)tsFolder);
                if (testStep.getTestStepName().equalsIgnoreCase("output")) {
                    return;
                }
                testCase.getTestSteps().add(testStep);
                FileUtils.listFolders(tsFolder).forEach(connFolder -> {
                    ConnectorRef connectorRef = new ConnectorRef((File)connFolder);
                    FileUtils.listFiles(connFolder).forEach(payload -> {
                        if (!payload.getName().equals(".gitignore") && !payload.getName().equals("description.txt")) {
                            connectorRef.getPayloads().add(new Payload((File)payload));
                        }
                    });
                    testStep.getConnectorRefs().add(connectorRef);
                });
            });
        });
        return holder;
    }

    public void testCasesHolderToYaml(TestCasesHolder holder) throws IOException {
        ConfigUtils.writeModelObjToYaml(holder, this.getFullPath() + this.getTestcasesFileName());
    }

    public TestCasesHolder testCasesHolderFromFileSystemToYaml() throws IOException {
        TestCasesHolder holder = this.testCasesHolderFromFileSystem();
        this.testCasesHolderToYaml(holder);
        return holder;
    }

    public String getTestcasesFileName() {
        return this.testcasesFileName;
    }

    public void setTestcasesFileName(String testcasesFileName) {
        this.testcasesFileName = testcasesFileName;
    }

    public String contextAsString() {
        return "[ filename: " + this.getTestcasesFileName() + ", absPath: " + this.getAbsolutePath() + ", relPath: " + this.getRelativePath() + "]";
    }

    public TestCasesHolder getTestCasesHolder() {
        return this.testCasesHolder;
    }

    public void setTestCasesHolder(TestCasesHolder testCasesHolder) {
        this.testCasesHolder = testCasesHolder;
    }
}

