/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration.model;

import com.rockit.common.blackboxtester.suite.configuration.TestProtocol;
import io.github.rockitconsulting.test.rockitizer.configuration.model.Environment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvironmentsHolder {
    private List<Environment> envs = new ArrayList<Environment>();

    public List<Environment> getEnvs() {
        return this.envs;
    }

    public void setEnvs(List<Environment> envs) {
        this.envs = envs;
    }

    public Map<String, String> getProps(String pEnvName) {
        if (pEnvName == null && this.isValid()) {
            TestProtocol.writeWarn("env.yaml exists, but environment param not provided. Replacing placeholders in resources.yaml with first environment: " + this.getEnvs().get(0).getName());
            return this.getFirstEnvironment();
        }
        if (this.checkExistsEnvByName(pEnvName)) {
            TestProtocol.write("env.yaml exists,  environment " + pEnvName + " found. Replacing placeholders in resources.yaml");
            return this.getPropsByEnvName(pEnvName);
        }
        if (this.isValid()) {
            TestProtocol.writeWarn("env.yaml exists, but environment " + pEnvName + " not found. Replacing placeholders  in resources.yaml with first environment: " + this.getEnvs().get(0).getName());
            return this.getFirstEnvironment();
        }
        TestProtocol.writeWarn("env.yaml for environment variables exists, but not valid replacements found. Fallback to using of default resources.yaml");
        return null;
    }

    private Map<String, String> getFirstEnvironment() {
        return this.getEnvs().get(0).getProps();
    }

    private boolean isValid() {
        return !this.getEnvs().isEmpty() && this.getFirstEnvironment() != null;
    }

    private Map<String, String> getPropsByEnvName(String pEnvName) {
        HashMap<String, String> props = new HashMap<String, String>();
        this.getEnvs().forEach(env -> {
            if (props.isEmpty() || env.getName().equalsIgnoreCase(pEnvName)) {
                props.putAll(env.getProps());
            }
        });
        return props;
    }

    private boolean checkExistsEnvByName(String pEnvName) {
        return this.getEnvs().stream().filter(e -> e.getName().equalsIgnoreCase(pEnvName)).findFirst().orElse(null) != null;
    }
}

