/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration.model;

import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.HTTPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.MQConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.SCPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.DBDataSource;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.KeyStore;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.datasources.MQDataSource;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.ConnectorRef;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.exceptions.UnknownConnectorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcesHolder {
    private Map<String, String> payloadReplacer = new HashMap<String, String>();
    private List<DBConnectorCfg> dbConnectors = new ArrayList<DBConnectorCfg>();
    private List<HTTPConnectorCfg> httpConnectors = new ArrayList<HTTPConnectorCfg>();
    private List<FileConnectorCfg> fileConnectors = new ArrayList<FileConnectorCfg>();
    private List<MQConnectorCfg> mqConnectors = new ArrayList<MQConnectorCfg>();
    private List<SCPConnectorCfg> scpConnectors = new ArrayList<SCPConnectorCfg>();
    private List<MQDataSource> mqDataSources = new ArrayList<MQDataSource>();
    private List<DBDataSource> dbDataSources = new ArrayList<DBDataSource>();
    private List<KeyStore> keyStores = new ArrayList<KeyStore>();

    public List<MQDataSource> getMqDataSources() {
        return this.mqDataSources;
    }

    public void setMqDataSources(List<MQDataSource> mqDataSources) {
        this.mqDataSources = mqDataSources;
    }

    public List<DBDataSource> getDbDataSources() {
        return this.dbDataSources;
    }

    public void setDbDataSources(List<DBDataSource> dbDataSources) {
        this.dbDataSources = dbDataSources;
    }

    public List<KeyStore> getKeyStores() {
        return this.keyStores;
    }

    public void setKeyStores(List<KeyStore> keyStores) {
        this.keyStores = keyStores;
    }

    public List<DBConnectorCfg> getDbConnectors() {
        return this.dbConnectors;
    }

    public void setDbConnectors(List<DBConnectorCfg> dbConnectors) {
        this.dbConnectors = dbConnectors;
    }

    public List<HTTPConnectorCfg> getHttpConnectors() {
        return this.httpConnectors;
    }

    public void setHttpConnectors(List<HTTPConnectorCfg> httpConnectors) {
        this.httpConnectors = httpConnectors;
    }

    public List<FileConnectorCfg> getFileConnectors() {
        return this.fileConnectors;
    }

    public void setFileConnectors(List<FileConnectorCfg> fileConnectors) {
        this.fileConnectors = fileConnectors;
    }

    public List<MQConnectorCfg> getMqConnectors() {
        return this.mqConnectors;
    }

    public void setMqConnectors(List<MQConnectorCfg> mqConnectors) {
        this.mqConnectors = mqConnectors;
    }

    public List<SCPConnectorCfg> getScpConnectors() {
        return this.scpConnectors;
    }

    public void setScpConnectors(List<SCPConnectorCfg> scpConnectors) {
        this.scpConnectors = scpConnectors;
    }

    public void addHttpConnector(HTTPConnectorCfg httpConnector) {
        if (!this.getHttpConnectors().stream().anyMatch(c -> c.getId().equals(httpConnector.getId()))) {
            this.getHttpConnectors().add(httpConnector);
        }
    }

    public void addFileConnector(FileConnectorCfg fileConnector) {
        if (!this.getFileConnectors().stream().anyMatch(c -> c.getId().equals(fileConnector.getId()))) {
            this.getFileConnectors().add(fileConnector);
        }
    }

    public void addMqConnector(MQConnectorCfg mqConnector) {
        if (!this.getMqConnectors().stream().anyMatch(c -> c.getId().equals(mqConnector.getId()))) {
            this.getMqConnectors().add(mqConnector);
        }
    }

    public void addDbConnector(DBConnectorCfg dbConnector) {
        if (!this.getDbConnectors().stream().anyMatch(c -> c.getId().equals(dbConnector.getId()))) {
            this.getDbConnectors().add(dbConnector);
        }
    }

    public void addScpConnector(SCPConnectorCfg scpConnector) {
        if (!this.getScpConnectors().stream().anyMatch(c -> c.getId().equals(scpConnector.getId()))) {
            this.getScpConnectors().add(scpConnector);
        }
    }

    public DBDataSource findDBDataSourceById(String id) {
        return this.getDbDataSources().stream().filter(c -> c.getId().equals(id)).findAny().orElse(null);
    }

    public MQDataSource findMQDataSourceById(String id) {
        return this.getMqDataSources().stream().filter(c -> c.getId().equals(id)).findAny().orElse(null);
    }

    public KeyStore findKeyStoreById(String id) {
        return this.getKeyStores().stream().filter(c -> c.getId().equals(id)).findAny().orElse(null);
    }

    public Object findResourceByRef(ConnectorRef conRef) {
        String cType = ConfigUtils.connectorTypeFromConnectorId(conRef.getConRefId());
        Object result = null;
        switch (cType) {
            case "HTTP": {
                result = this.getHttpConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "FILEDEL": {
                result = this.getFileConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "FILEPUT": {
                result = this.getFileConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "FILEGET": {
                result = this.getFileConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "MQGET": {
                result = this.getMqConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "MQPUT": {
                result = this.getMqConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "DBPUT": {
                result = this.getDbConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "DBGET": {
                result = this.getDbConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            case "SCPPUT": {
                result = this.getScpConnectors().stream().filter(c -> c.getId().equals(conRef.getConRefId())).findAny().orElse(null);
                break;
            }
            default: {
                throw new UnknownConnectorException(conRef.getConRefId());
            }
        }
        return result;
    }

    public Map<String, String> getPayloadReplacer() {
        return this.payloadReplacer;
    }

    public void setPayloadReplacer(Map<String, String> payloadReplacer) {
        this.payloadReplacer = payloadReplacer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + System.lineSeparator() + " [ " + (this.mqDataSources.isEmpty() ? "" : ", mqDataSources=" + this.mqDataSources + System.lineSeparator()) + (this.dbDataSources.isEmpty() ? "" : ", dbDataSources=" + this.dbDataSources + System.lineSeparator()) + (this.keyStores.isEmpty() ? "" : ", keyStores=" + this.keyStores + System.lineSeparator()) + (this.scpConnectors.isEmpty() ? "" : ", scpConnectors=" + this.scpConnectors + System.lineSeparator()) + (this.payloadReplacer.isEmpty() ? "" : ", payloadReplacer=" + this.payloadReplacer + System.lineSeparator()) + "]";
    }
}

