/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors;

import io.github.rockitconsulting.test.rockitizer.validation.Validatable;
import io.github.rockitconsulting.test.rockitizer.validation.model.Context;
import io.github.rockitconsulting.test.rockitizer.validation.model.Message;
import java.beans.Transient;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class BaseConnector
implements Validatable {
    private String id;
    private Context context;

    public BaseConnector() {
    }

    public BaseConnector(File location) {
        this.id = location.getName();
        this.context = new Context.Builder().withConnector(location);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isValid() {
        return this.validate().size() == 0;
    }

    @Override
    public abstract Map<Context, List<Message>> validate();

    @Override
    @Transient
    public Context getContext() {
        if (this.context == null) {
            this.context = new Context.Builder().withId(this.getId());
        }
        return this.context;
    }

    @Transient
    public void setContext(Context context) {
        this.context = context;
    }

    public abstract String toString();

    public static enum Types {
        DBGET,
        DBPUT,
        FILEDEL,
        FILEPUT,
        FILEGET,
        HTTP,
        SCPPUT,
        MQGET,
        MQPUT;

    }
}

