/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration.utils;

import io.github.rockitconsulting.test.rockitizer.configuration.model.EnvironmentsHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.ResourcesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.TestCasesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.snakeyaml.ConfigurationModelRepresenter;
import io.github.rockitconsulting.test.rockitizer.validation.ValidationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigUtils {
    public static final String getAbsolutePathToRoot() {
        String path = new File("").getAbsolutePath();
        if (System.getProperty("basedir") != null && System.getProperty("app.home") != null) {
            path = path.replace("\\bin", "").replace("\\target", "").replace("\\appassembler", "");
        }
        return path.replace("\\", "/");
    }

    public static final String getAbsolutePathToResources() {
        return ConfigUtils.getAbsolutePathToRoot() + "/src/test/resources/";
    }

    public static final String getAbsolutePathToJava() {
        return ConfigUtils.getAbsolutePathToRoot() + "/src/test/java/";
    }

    public static String connectorTypeFromFolder(File connFolder) {
        return ConfigUtils.connectorTypeFromConnectorId(connFolder.getName());
    }

    public static String connectorTypeFromConnectorId(String connId) {
        ValidationUtils.validateConnector(connId);
        return connId.split("\\.")[0];
    }

    public static void writeModelObjToYaml(Object container, String yamlFileNameWithAbsPath) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        ConfigurationModelRepresenter customRepresenter = new ConfigurationModelRepresenter();
        Yaml yaml = new Yaml((Representer)customRepresenter, options);
        try (FileWriter fw = new FileWriter(yamlFileNameWithAbsPath, false);){
            fw.write("#########################################################################################################################" + System.lineSeparator());
            fw.write("############### This file has been generated. Kindly consider to replace the @@ placeholders with your values ###########" + System.lineSeparator());
            fw.write("#########################################################################################################################" + System.lineSeparator());
            fw.write(yaml.dumpAsMap(container));
        }
    }

    public static ResourcesHolder resourcesHolderFromYaml(String path) throws IOException {
        Constructor constructor = new Constructor(ResourcesHolder.class);
        TypeDescription customTypeDescription = new TypeDescription(ResourcesHolder.class);
        constructor.addTypeDescription(customTypeDescription);
        FileInputStream inputStream = new FileInputStream(path);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (ResourcesHolder)yaml.load((InputStream)inputStream);
    }

    public static TestCasesHolder testCasesHolderFromYaml(String path) throws IOException {
        Constructor constructor = new Constructor(TestCasesHolder.class);
        TypeDescription customTypeDescription = new TypeDescription(TestCasesHolder.class);
        constructor.addTypeDescription(customTypeDescription);
        FileInputStream inputStream = new FileInputStream(path);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (TestCasesHolder)yaml.load((InputStream)inputStream);
    }

    public static EnvironmentsHolder envrironmentsHolderFromYaml(String path) throws IOException {
        Constructor constructor = new Constructor(EnvironmentsHolder.class);
        TypeDescription customTypeDescription = new TypeDescription(EnvironmentsHolder.class);
        constructor.addTypeDescription(customTypeDescription);
        try {
            FileInputStream inputStream = new FileInputStream(path);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            return (EnvironmentsHolder)yaml.load((InputStream)inputStream);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }
}

