/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.configuration.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.rockit.common.blackboxtester.exceptions.GenericException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;

public class FileUtils {
    public static final Logger LOGGER = Logger.getLogger((String)FileUtils.class.getName());

    public static Iterable<File> listFolders(final File root) {
        return Iterables.filter((Iterable)Files.fileTraverser().breadthFirst((Object)root), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.isDirectory() && input.getParentFile().equals(root);
            }

            public boolean test(File input) {
                return this.apply(input);
            }
        });
    }

    public static Iterable<File> listFiles(File root) {
        return FileUtils.listFiles(root, false);
    }

    public static Iterable<File> listFiles(final File root, final boolean ignoreGitIgnore) {
        return Iterables.filter((Iterable)Files.fileTraverser().breadthFirst((Object)root), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                if (!ignoreGitIgnore) {
                    return input.isFile() && input.getParentFile().equals(root);
                }
                return input.isFile() && input.getParentFile().equals(root) && !input.getName().equalsIgnoreCase(".gitignore");
            }

            public boolean test(File input) {
                return this.apply(input);
            }
        });
    }

    public static File lastFile(File root) {
        Iterable<File> listFiles = FileUtils.listFiles(root, true);
        return StreamSupport.stream(listFiles.spliterator(), false).filter(f -> !f.isDirectory()).max(Comparator.comparingLong(f -> f.lastModified())).orElse(null);
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            org.apache.commons.io.FileUtils.copyDirectory((File)from, (File)to);
        } else if (from.isFile() && to.isDirectory()) {
            org.apache.commons.io.FileUtils.copyFileToDirectory((File)from, (File)to);
        } else {
            Files.copy((File)from, (File)to);
        }
    }

    public static void deleteDirectory(File file) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("cannot delete " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    public static String readFile(String path) throws IOException {
        return Joiner.on((String)System.lineSeparator()).join((Iterable)Files.readLines((File)new File(path), (Charset)Charsets.UTF_8));
    }

    public static String readFile(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            return FileUtils.readFile(f.getAbsolutePath());
        }
        catch (IOException ioex) {
            LOGGER.warn((Object)"cannot load description", (Throwable)ioex);
            return null;
        }
    }

    public static byte[] getContents(File file) {
        byte[] content;
        try {
            content = Files.toByteArray((File)file);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            throw new GenericException(e);
        }
        return content;
    }

    public static void deleteFilesRecursive(File f) {
        if (f.exists() && f.isDirectory()) {
            File[] files;
            for (File ff : files = f.listFiles()) {
                FileUtils.deleteFilesRecursive(ff);
            }
        } else if (f.exists() && !f.delete()) {
            LOGGER.warn((Object)("cannot delete " + f.getAbsolutePath() + " ,  permissions: canRead " + f.canRead() + ", canExecute " + f.canExecute() + ", canWrite " + f.canWrite()));
        }
    }
}

