/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.validation;

import com.rockit.common.blackboxtester.suite.configuration.Constants;
import io.github.rockitconsulting.test.rockitizer.configuration.Configuration;
import io.github.rockitconsulting.test.rockitizer.configuration.model.ResourcesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.TestCasesHolder;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.DBConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.FileConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.HTTPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.MQConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.res.connectors.SCPConnectorCfg;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.ConnectorRef;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.TestCase;
import io.github.rockitconsulting.test.rockitizer.configuration.model.tc.TestStep;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.ConfigUtils;
import io.github.rockitconsulting.test.rockitizer.configuration.utils.FileUtils;
import io.github.rockitconsulting.test.rockitizer.exceptions.InvalidConnectorFormatException;
import io.github.rockitconsulting.test.rockitizer.exceptions.ResourceNotFoundException;
import io.github.rockitconsulting.test.rockitizer.exceptions.ValidationException;
import io.github.rockitconsulting.test.rockitizer.validation.Validatable;
import io.github.rockitconsulting.test.rockitizer.validation.ValidationHolder;
import io.github.rockitconsulting.test.rockitizer.validation.model.Context;
import io.github.rockitconsulting.test.rockitizer.validation.model.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;

public class ValidationUtils {
    public static void validateConnector(String connId) {
        if (!connId.contains(".") || !Constants.SUPPORTED_CONNECTORS.contains(connId.split("\\.")[0])) {
            throw new InvalidConnectorFormatException(connId);
        }
    }

    public static Map<Context, List<Message>> checkFieldsValid(Context context, Map<String, String> fields) {
        ArrayList messages = new ArrayList();
        fields.forEach((f, v) -> ValidationUtils.checkValid(f, v, messages));
        LinkedHashMap<Context, List<Message>> res = new LinkedHashMap<Context, List<Message>>();
        if (!messages.isEmpty()) {
            res.put(context, messages);
        }
        return res;
    }

    public static void validateConnectorRefExists() {
        Configuration.configuration().getTchApi().getTestCasesHolder().getTestCases().forEach(tc -> tc.getTestSteps().forEach(ts -> ts.getConnectorRefs().forEach(conRef -> {
            Object conn = Configuration.configuration().getRhApi().getResourcesHolder().findResourceByRef((ConnectorRef)conRef);
            if (conn == null) {
                ValidationHolder.validationHolder().add(new Context.Builder().withId(conRef.getConRefId()), new Message(Message.LEVEL.ERROR, "Connector " + conRef.getConRefId() + " exists in testcases but not in resources"));
            } else {
                ValidationUtils.validateDataSourceRefForConnector(conn);
            }
        })));
    }

    private static void validateDataSourceRefForConnector(Object conn) {
        if (conn instanceof DBConnectorCfg) {
            try {
                Configuration.configuration().getDBDataSourceByConnector((DBConnectorCfg)conn);
            }
            catch (ResourceNotFoundException rnfe) {
                ValidationUtils.registerValidationErrorDataSourceNotFound(((DBConnectorCfg)conn).getId(), ((DBConnectorCfg)conn).getDsRefId());
            }
            catch (ValidationException rnfe) {}
        } else if (conn instanceof MQConnectorCfg) {
            try {
                Configuration.configuration().getMQDataSourceByConnector((MQConnectorCfg)conn);
            }
            catch (ResourceNotFoundException rnfe) {
                ValidationUtils.registerValidationErrorDataSourceNotFound(((MQConnectorCfg)conn).getId(), ((MQConnectorCfg)conn).getDsRefId());
            }
            catch (ValidationException rnfe) {
                // empty catch block
            }
        }
        if (conn instanceof HTTPConnectorCfg) {
            try {
                Configuration.configuration().getKeyStoreByConnector((HTTPConnectorCfg)conn);
            }
            catch (ResourceNotFoundException rnfe) {
                ValidationUtils.registerValidationErrorDataSourceNotFound(((HTTPConnectorCfg)conn).getId(), ((HTTPConnectorCfg)conn).getDsRefId());
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
    }

    private static void registerValidationErrorDataSourceNotFound(String id, String dsRefId) {
        ValidationHolder.validationHolder().add(new Context.Builder().withId(id), new Message(Message.LEVEL.ERROR, "Connector " + id + " references to non-existing datasource " + dsRefId));
    }

    public static void cleanGitIgnore() {
        Iterable<File> testCases = FileUtils.listFolders(new File(Configuration.configuration().getFullPath()));
        testCases.forEach(tcase -> FileUtils.listFolders(tcase).forEach(tstep -> {
            if (tstep.getName().equalsIgnoreCase("output")) {
                return;
            }
            FileUtils.listFolders(tstep).forEach(connector -> FileUtils.listFiles(connector).forEach(payload -> {
                if (payload.getName().equals(".gitignore")) {
                    payload.delete();
                }
            }));
        }));
    }

    public static void fixGitEmptyFoldersProblem() {
        Iterable<File> testCases = FileUtils.listFolders(new File(Configuration.configuration().getFullPath()));
        testCases.forEach(tcase -> FileUtils.listFolders(tcase).forEach(tstep -> {
            if (tstep.getName().equalsIgnoreCase("output")) {
                return;
            }
            FileUtils.listFolders(tstep).forEach(connector -> {
                if (!FileUtils.listFiles(connector).iterator().hasNext()) {
                    try {
                        new File(connector.getAbsolutePath() + File.separator + ".gitignore").createNewFile();
                        ValidationHolder.validationHolder().add(new Context.Builder().withConnector((File)connector), new Message(Message.LEVEL.WARN, "Connector is empty. Creating the .gitignore file to enforce the github checkin "));
                    }
                    catch (Exception e) {
                        ValidationHolder.validationHolder().add(new Context.Builder().withConnector((File)connector), new Message(Message.LEVEL.ERROR, "Connector is empty. Creating the .gitignore failed with error " + e.getMessage()));
                    }
                }
            });
        }));
    }

    public static void validateResources() {
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getMqConnectors());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getDbConnectors());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getFileConnectors());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getHttpConnectors());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getScpConnectors());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getMqDataSources());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getDbDataSources());
        ValidationUtils.validateResources(Configuration.configuration().getRhApi().getResourcesHolder().getKeyStores());
    }

    public static List<String> syncConfig() throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        ResourcesHolder rhyaml = Configuration.configuration().getRhApi().resourcesHolderFromYaml(true);
        ResourcesHolder rhfs = Configuration.configuration().getRhApi().resourcesHolderFromFileSystem();
        rhfs.getDbConnectors().forEach(c -> {
            DBConnectorCfg match = rhyaml.getDbConnectors().stream().filter(yc -> yc.getId().equals(c.getId())).findAny().orElse(null);
            if (match == null) {
                messages.add("sync to yaml: " + c.toString());
                rhyaml.addDbConnector((DBConnectorCfg)c);
            }
        });
        rhfs.getMqConnectors().forEach(c -> {
            MQConnectorCfg match = rhyaml.getMqConnectors().stream().filter(yc -> yc.getId().equals(c.getId())).findAny().orElse(null);
            if (match == null) {
                messages.add("sync to yaml: " + c.toString());
                rhyaml.addMqConnector((MQConnectorCfg)c);
            }
        });
        rhfs.getFileConnectors().forEach(c -> {
            FileConnectorCfg match = rhyaml.getFileConnectors().stream().filter(yc -> yc.getId().equals(c.getId())).findAny().orElse(null);
            if (match == null) {
                messages.add("sync to yaml: " + c.toString());
                rhyaml.addFileConnector((FileConnectorCfg)c);
            }
        });
        rhfs.getHttpConnectors().forEach(c -> {
            HTTPConnectorCfg match = rhyaml.getHttpConnectors().stream().filter(yc -> yc.getId().equals(c.getId())).findAny().orElse(null);
            if (match == null) {
                messages.add("sync to yaml: " + c.toString());
                rhyaml.addHttpConnector((HTTPConnectorCfg)c);
            }
        });
        rhfs.getScpConnectors().forEach(c -> {
            SCPConnectorCfg match = rhyaml.getScpConnectors().stream().filter(yc -> yc.getId().equals(c.getId())).findAny().orElse(null);
            if (match == null) {
                messages.add("sync to yaml: " + c.toString());
                rhyaml.addScpConnector((SCPConnectorCfg)c);
            }
        });
        Configuration.configuration().getTchApi().testCasesHolderFromFileSystemToYaml();
        Configuration.configuration().getRhApi().resourcesHolderToYaml(rhyaml);
        return messages;
    }

    public static void validateTestCasesAndFileSystemInSync() throws IOException {
        String testcases = Configuration.configuration().getTchApi().getTestcasesFileName();
        TestCasesHolder tch1 = Configuration.configuration().getTchApi().testCasesHolderFromYaml();
        TestCasesHolder tch2 = Configuration.configuration().getTchApi().testCasesHolderFromFileSystem();
        ValidationUtils.validateAndCollectErrorContext(tch1, tch2).forEach(c -> ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.ERROR, "exists in " + testcases + ", but not found in FileSystem")));
        ValidationUtils.validateAndCollectErrorContext(tch2, tch1).forEach(c -> ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.ERROR, "exists in FileSystem, but not found in " + testcases)));
    }

    private static List<Context> validateAndCollectErrorContext(TestCasesHolder tch1, TestCasesHolder tch2) {
        ArrayList<Context> errorContext = new ArrayList<Context>();
        tch1.getTestCases().forEach(tc1 -> {
            TestCase matchCase = tch2.getTestCases().stream().filter(tc -> tc.equals(tc1)).findAny().orElse(null);
            if (matchCase == null) {
                errorContext.add(new Context.Builder().withTestCase(tc1.getTestCaseName()));
            } else {
                tc1.getTestSteps().forEach(ts1 -> {
                    TestStep matchStep = matchCase.getTestSteps().stream().filter(ts2 -> ts2.equals(ts1)).findAny().orElse(null);
                    if (matchStep == null) {
                        errorContext.add(new Context.Builder().withTestStep(tc1.getTestCaseName(), ts1.getTestStepName()));
                    } else {
                        ts1.getConnectorRefs().forEach(cref1 -> {
                            ConnectorRef matchCref2 = matchStep.getConnectorRefs().stream().filter(conreffs -> conreffs.equals(cref1)).findAny().orElse(null);
                            if (matchCref2 == null) {
                                errorContext.add(new Context.Builder().withConnector(tc1.getTestCaseName(), ts1.getTestStepName(), cref1.getConRefId()));
                            }
                        });
                    }
                });
            }
        });
        return errorContext;
    }

    public static void validateNotAllowedEmptyStructures() throws IOException {
        String testcases = Configuration.configuration().getTchApi().getTestcasesFileName();
        TestCasesHolder tch1 = Configuration.configuration().getTchApi().testCasesHolderFromYaml();
        TestCasesHolder tch2 = Configuration.configuration().getTchApi().testCasesHolderFromFileSystem();
        ValidationUtils.validateNotAllowedEmptyStructures(tch1).forEach(c -> {
            if (c.getConnector() != null) {
                ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.WARN, "PUT connector must have payloads in " + testcases));
            } else {
                ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.WARN, "empty structure in " + testcases));
            }
        });
        ValidationUtils.validateNotAllowedEmptyStructures(tch2).forEach(c -> {
            if (c.getConnector() != null) {
                ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.WARN, "PUT connector must have payloads in FileSystem"));
            } else {
                ValidationHolder.validationHolder().add((Context)c, new Message(Message.LEVEL.WARN, "empty structure in FileSystem"));
            }
        });
    }

    public static void validateSyncJavaAndTestCases() {
        Iterable<File> testCases = FileUtils.listFolders(new File(Configuration.configuration().getFullPath()));
        Iterable<File> junits = FileUtils.listFiles(new File(ConfigUtils.getAbsolutePathToJava()));
        testCases.forEach(tcase -> {
            File match = StreamSupport.stream(junits.spliterator(), false).filter(ju -> ju.getName().replace(".java", "").equals(tcase.getName())).findAny().orElse(null);
            if (match == null) {
                ValidationHolder.validationHolder().add(new Context.Builder().withTestCase((File)tcase), new Message(Message.LEVEL.WARN, "Testcase exists but matching Junit [" + tcase.getName() + ".java] cannot be found under " + ConfigUtils.getAbsolutePathToJava()));
            }
        });
        junits.forEach(junit -> {
            File match = StreamSupport.stream(testCases.spliterator(), false).filter(tc -> tc.getName().equals(junit.getName().replace(".java", ""))).findAny().orElse(null);
            if (match == null) {
                ValidationHolder.validationHolder().add(new Context.Builder().withId(junit.getName()), new Message(Message.LEVEL.WARN, "Junit [" + junit.getName() + "]   exists but matching TestCase [" + junit.getName().replace(".java", "") + "] cannot be found under " + ConfigUtils.getAbsolutePathToResources()));
            }
        });
    }

    private static List<Context> validateNotAllowedEmptyStructures(TestCasesHolder tch1) {
        ArrayList<Context> errorContext = new ArrayList<Context>();
        tch1.getTestCases().forEach(tc1 -> {
            if (tc1.getTestSteps().isEmpty()) {
                errorContext.add(new Context.Builder().withTestCase(tc1.getTestCaseName()));
                return;
            }
            tc1.getTestSteps().forEach(ts1 -> {
                if (ts1.getConnectorRefs().isEmpty() && !ts1.getTestStepName().equals("000BEFORE") && !ts1.getTestStepName().equals("999AFTER")) {
                    errorContext.add(new Context.Builder().withTestStep(tc1.getTestCaseName(), ts1.getTestStepName()));
                    return;
                }
                ts1.getConnectorRefs().forEach(c -> {
                    if (!ValidationUtils.isConnectorPayloadsValid(c)) {
                        errorContext.add(new Context.Builder().withConnector(tc1.getTestCaseName(), ts1.getTestStepName(), c.getConRefId()));
                    }
                });
            });
        });
        return errorContext;
    }

    private static boolean isConnectorPayloadsValid(ConnectorRef c) {
        String type = ConfigUtils.connectorTypeFromConnectorId(c.getConRefId());
        return !type.endsWith("PUT") || !c.getPayloads().isEmpty();
    }

    private static void validateResources(List<? extends Validatable> validatables) {
        validatables.forEach(c -> ValidationHolder.validationHolder().addAll(c.validate()));
    }

    private static void checkValid(String paramName, String paramValue, List<Message> messages) {
        Pattern placeholderPattern = Pattern.compile("^\\$\\{.*\\}");
        if (paramValue == null) {
            messages.add(new Message(Message.LEVEL.ERROR, " mandatory param [" + paramName + "] cannot be 'null'"));
        } else if (paramValue.startsWith("@") && paramValue.endsWith("@")) {
            messages.add(new Message(Message.LEVEL.ERROR, " mandatory param [" + paramName + "] with value '" + paramValue + "' must exist and cannot contain @placeholders@"));
        } else if (placeholderPattern.matcher(paramValue).matches()) {
            messages.add(new Message(Message.LEVEL.ERROR, " param [" + paramName + "] with value '" + paramValue + "' cannot contain ${placeholders}. Please define the value for the placeholder in the envs.yaml file under the corresponding environment"));
        }
    }
}

