/*
 * Decompiled with CFR 0.152.
 */
package io.github.rockitconsulting.test.rockitizer.validation.model;

import java.io.File;

public class Context {
    private String id;
    private String rootPath;
    private String testCase;
    private String testStep;
    private String connector;

    private Context(Builder builder) {
        this.connector = builder.connector;
        this.testStep = builder.testStep;
        this.testCase = builder.testCase;
        this.rootPath = builder.rootPath;
        this.id = builder.id;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getTestCase() {
        return this.testCase;
    }

    public String getTestStep() {
        return this.testStep;
    }

    public String getConnector() {
        return this.connector;
    }

    public String toString() {
        return "Context [" + (this.id != null ? " id=" + this.id : "") + (this.rootPath != null ? " rootPath=" + this.rootPath : "") + (this.testCase != null ? " testCase=" + this.testCase : "") + (this.testStep != null ? " testStep=" + this.testStep : "") + (this.connector != null ? " connector=" + this.connector : "") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connector == null ? 0 : this.connector.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.rootPath == null ? 0 : this.rootPath.hashCode());
        result = 31 * result + (this.testCase == null ? 0 : this.testCase.hashCode());
        result = 31 * result + (this.testStep == null ? 0 : this.testStep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        if (this.connector == null ? other.connector != null : !this.connector.equals(other.connector)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.rootPath == null ? other.rootPath != null : !this.rootPath.equals(other.rootPath)) {
            return false;
        }
        if (this.testCase == null ? other.testCase != null : !this.testCase.equals(other.testCase)) {
            return false;
        }
        return !(this.testStep == null ? other.testStep != null : !this.testStep.equals(other.testStep));
    }

    public static class Builder {
        private String id;
        private String rootPath;
        private String testCase;
        private String testStep;
        private String connector;

        public Context withConnector(String testCase, String testStep, String connector) {
            this.connector = connector;
            this.testStep = testStep;
            this.testCase = testCase;
            return new Context(this);
        }

        public Context withTestStep(String testCase, String testStep) {
            this.testStep = testStep;
            this.testCase = testCase;
            return new Context(this);
        }

        public Context withTestCase(String testCase) {
            this.testCase = testCase;
            return new Context(this);
        }

        public Context withConnector(File connectorFolder) {
            this.connector = connectorFolder.getName();
            this.testStep = connectorFolder.getParentFile().getName();
            this.testCase = connectorFolder.getParentFile().getParentFile().getName();
            this.rootPath = connectorFolder.getParentFile().getParentFile().getParentFile().getAbsolutePath();
            return new Context(this);
        }

        public Context withTesStep(File stepFolder) {
            this.testStep = stepFolder.getName();
            this.testCase = stepFolder.getParentFile().getName();
            this.rootPath = stepFolder.getParentFile().getParentFile().getAbsolutePath();
            return new Context(this);
        }

        public Context withTestCase(File caseFolder) {
            this.testCase = caseFolder.getName();
            this.rootPath = caseFolder.getParentFile().getAbsolutePath();
            return new Context(this);
        }

        public Context withId(String id) {
            this.id = id;
            return new Context(this);
        }
    }
}

